/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype.layer;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.client.render.rendertype.layer.CompositeRenderTypeData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class DynamicRenderTypeManager
extends SimplePreparableReloadListener<Map<ResourceLocation, byte[]>> {
    private static final FileToIdConverter CONVERTER = FileToIdConverter.json((String)"pinwheel/rendertypes");

    @NotNull
    protected Map<ResourceLocation, byte[]> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, byte[]> data = new HashMap<ResourceLocation, byte[]>();
        Map resources = CONVERTER.listMatchingResources(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            ResourceLocation id = CONVERTER.fileToId(location);
            try {
                InputStream stream = ((Resource)entry.getValue()).open();
                try {
                    data.put(id, stream.readAllBytes());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't read data file {} from {}", new Object[]{id, location, e});
            }
        }
        return data;
    }

    protected void apply(Map<ResourceLocation, byte[]> fileData, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, RenderType> renderTypes = new HashMap<ResourceLocation, RenderType>();
        int injections = 0;
        for (Map.Entry<ResourceLocation, byte[]> entry : fileData.entrySet()) {
            ResourceLocation id = entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(entry.getValue()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                DataResult result = CompositeRenderTypeData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(((DataResult.PartialResult)result.error().get()).message());
                }
                CompositeRenderTypeData data = (CompositeRenderTypeData)result.result().orElseThrow();
                if (data.inject() != null) {
                    ++injections;
                    continue;
                }
                if (renderTypes.put(id, data.createRenderType(id.toString())) == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + id);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, CONVERTER.idToFile(id), e});
            }
        }
        Veil.LOGGER.info("Loaded {} render types", (Object)(renderTypes.size() + injections));
    }
}

