/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilDeferredRenderer
implements PreparableReloadListener,
NativeResource {
    public static final ResourceLocation PACK_ID = Veil.veilPath("deferred");
    public static final String DISABLE_VANILLA_ENTITY_LIGHT_KEY = "DISABLE_VANILLA_ENTITY_LIGHT";
    public static final ResourceLocation OPAQUE_POST = Veil.veilPath("core/opaque");
    public static final ResourceLocation LIGHT_POST = Veil.veilPath("core/light");
    public static final ResourceLocation OPAQUE_MIX = Veil.veilPath("core/mix_opaque");
    public static final ResourceLocation TRANSPARENT_MIX = Veil.veilPath("core/mix_transparent");
    public static final ResourceLocation TRANSPARENT_POST = Veil.veilPath("core/transparent");
    public static final ResourceLocation SCREEN_POST = Veil.veilPath("core/screen");
    public static final MutableComponent UNSUPPORTED_TITLE = Component.translatable((String)"veil.deferred.unsupported.title");
    public static final MutableComponent UNSUPPORTED_SODIUM_DESC = Component.translatable((String)"veil.deferred.unsupported.sodium_desc");
    public static final MutableComponent UNSUPPORTED_FABULOUS_DESC = Component.translatable((String)"veil.deferred.unsupported.fabulous_desc");
    private final ShaderManager deferredShaderManager;
    private final ShaderPreDefinitions shaderPreDefinitions;
    private final FramebufferManager framebufferManager;
    private final PostProcessingManager postProcessingManager;
    private final LightRenderer lightRenderer;
    private boolean enabled;
    private RendererState state;

    public VeilDeferredRenderer(ShaderManager deferredShaderManager, ShaderPreDefinitions shaderPreDefinitions, FramebufferManager framebufferManager, PostProcessingManager postProcessingManager) {
        this.deferredShaderManager = deferredShaderManager;
        this.shaderPreDefinitions = shaderPreDefinitions;
        this.framebufferManager = framebufferManager;
        this.postProcessingManager = postProcessingManager;
        this.lightRenderer = new LightRenderer();
        this.enabled = false;
        this.state = RendererState.INACTIVE;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            boolean active;
            boolean selected = Minecraft.getInstance().getResourcePackRepository().getSelectedIds().contains(PACK_ID.toString()) || resourceManager.listPacks().anyMatch(pack -> pack.packId().equals(PACK_ID.toString()));
            boolean bl = active = selected && VeilDeferredRenderer.isSupported();
            if (selected && Minecraft.useShaderTransparency()) {
                SystemToast.add((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)UNSUPPORTED_TITLE, (Component)UNSUPPORTED_FABULOUS_DESC);
            }
            if (this.enabled != active) {
                this.enabled = active;
                if (active) {
                    Veil.LOGGER.info("Deferred Renderer Enabled");
                } else {
                    Veil.LOGGER.info("Deferred Renderer Disabled");
                    return preparationBarrier.wait(null).thenRunAsync(this::free, gameExecutor);
                }
            }
            if (this.enabled) {
                return this.deferredShaderManager.reload(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }
            return preparationBarrier.wait(null);
        }, gameExecutor).thenCompose(future -> future);
    }

    public void free() {
        this.enabled = false;
        this.state = RendererState.INACTIVE;
        this.deferredShaderManager.close();
        this.lightRenderer.free();
    }

    @ApiStatus.Internal
    public void reset() {
        this.lightRenderer.free();
    }

    @ApiStatus.Internal
    public void setup() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        switch (this.state) {
            case OPAQUE: {
                AdvancedFbo deferredFramebuffer = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
                if (deferredFramebuffer == null) {
                    Veil.LOGGER.error("Missing deferred opaque buffer");
                    this.free();
                    return;
                }
                deferredFramebuffer.bind(true);
                break;
            }
            case TRANSLUCENT: {
                AdvancedFbo transparent = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
                if (transparent == null) {
                    Veil.LOGGER.error("Missing deferred transparent buffer");
                    this.free();
                    return;
                }
                transparent.bind(true);
            }
        }
    }

    @ApiStatus.Internal
    public void clear() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        switch (this.state) {
            case OPAQUE: 
            case TRANSLUCENT: {
                AdvancedFbo.unbind();
            }
        }
    }

    @ApiStatus.Internal
    public void beginOpaque() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.OPAQUE;
        AdvancedFbo deferred = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
        if (deferred == null) {
            Veil.LOGGER.error("Missing deferred opaque buffer");
            this.free();
        }
    }

    @ApiStatus.Internal
    public void beginTranslucent() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.TRANSLUCENT;
        AdvancedFbo transparent = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
        if (transparent == null) {
            Veil.LOGGER.error("Missing deferred transparent buffer");
            this.free();
            return;
        }
        AdvancedFbo deferredFramebuffer = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
        if (deferredFramebuffer != null) {
            deferredFramebuffer.resolveToAdvancedFbo(transparent, 256, 9728);
        }
    }

    private void run(ProfilerFiller profiler, AdvancedFbo deferred, AdvancedFbo light, ResourceLocation post, ResourceLocation mix) {
        PostPipeline mixPipeline;
        PostPipeline postPipeline = this.postProcessingManager.getPipeline(post);
        if (postPipeline != null) {
            profiler.push("post");
            this.postProcessingManager.runPipeline(postPipeline, false);
            profiler.pop();
        }
        profiler.push("draw_lights");
        light.bind(true);
        this.lightRenderer.render(deferred);
        profiler.pop();
        PostPipeline lightPipeline = this.postProcessingManager.getPipeline(LIGHT_POST);
        if (lightPipeline != null) {
            profiler.push("light_post");
            this.postProcessingManager.runPipeline(lightPipeline, false);
            profiler.pop();
        }
        if ((mixPipeline = this.postProcessingManager.getPipeline(mix)) != null) {
            profiler.push("mix");
            this.postProcessingManager.runPipeline(mixPipeline, false);
            profiler.pop();
        }
    }

    @ApiStatus.Internal
    public void blit() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            AdvancedFbo postFramebuffer = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.POST);
            if (postFramebuffer != null) {
                AdvancedFbo.getMainFramebuffer().resolveToAdvancedFbo(postFramebuffer);
            }
            return;
        }
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        profiler.push("veil_deferred");
        this.end();
        AdvancedFbo deferred = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
        AdvancedFbo transparent = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
        AdvancedFbo deferredLight = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE_LIGHT);
        AdvancedFbo transparentLight = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT_LIGHT);
        AdvancedFbo post = this.framebufferManager.getFramebuffer(VeilFramebuffers.POST);
        if (deferred == null || transparent == null || deferredLight == null || transparentLight == null || post == null) {
            Veil.LOGGER.error("Missing deferred light buffers");
            this.free();
            return;
        }
        profiler.push("setup_lights");
        this.lightRenderer.setup(VeilRenderer.getCullingFrustum());
        profiler.popPush("opaque_light");
        this.run(profiler, deferred, deferredLight, OPAQUE_POST, OPAQUE_MIX);
        profiler.popPush("transparent_light");
        this.run(profiler, transparent, transparentLight, TRANSPARENT_POST, TRANSPARENT_MIX);
        profiler.pop();
        this.lightRenderer.clear();
        profiler.push("screen_post");
        PostPipeline screenPipeline = this.postProcessingManager.getPipeline(SCREEN_POST);
        if (screenPipeline != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            this.postProcessingManager.runPipeline(screenPipeline, false);
            RenderSystem.disableBlend();
        }
        profiler.pop();
        profiler.pop();
    }

    @ApiStatus.Internal
    public void end() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.INACTIVE;
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        boolean ambientOcclusion = this.lightRenderer.isAmbientOcclusionEnabled();
        boolean vanillaLights = this.lightRenderer.isVanillaLightEnabled();
        boolean vanillaEntityLights = this.shaderPreDefinitions.getDefinition(DISABLE_VANILLA_ENTITY_LIGHT_KEY) == null;
        consumer.accept("Ambient Occlusion: " + (ambientOcclusion ? ChatFormatting.GREEN + "On" : ChatFormatting.RED + "Off"));
        consumer.accept("Vanilla Light: " + (vanillaLights ? ChatFormatting.GREEN + "On" : ChatFormatting.RED + "Off"));
        consumer.accept("Vanilla Entity Light: " + (vanillaEntityLights ? ChatFormatting.GREEN + "On" : ChatFormatting.RED + "Off"));
        this.lightRenderer.addDebugInfo(consumer);
    }

    public void enable() {
        this.state = RendererState.INACTIVE;
    }

    public void disable() {
        this.state = RendererState.DISABLED;
    }

    public boolean isEnabled() {
        return this.enabled && VeilDeferredRenderer.isSupported();
    }

    public static boolean isSupported() {
        return !Minecraft.useShaderTransparency() && !Veil.SODIUM;
    }

    public boolean isActive() {
        return this.isEnabled() && this.state.isActive();
    }

    public LightRenderer getLightRenderer() {
        return this.lightRenderer;
    }

    public RendererState getRendererState() {
        return this.state;
    }

    public ShaderManager getDeferredShaderManager() {
        return this.deferredShaderManager;
    }

    public static enum RendererState {
        DISABLED,
        INACTIVE,
        OPAQUE,
        TRANSLUCENT;


        public boolean isActive() {
            return this == OPAQUE || this == TRANSLUCENT;
        }
    }
}

