/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkinnedMesh;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilVertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class Skin {
    final Map<Integer, SkinnedMesh> boneToMesh = new HashMap<Integer, SkinnedMesh>();
    final ResourceLocation shader;
    final ResourceLocation texture;
    VertexBuffer mesh = null;

    private Skin(ResourceLocation shader, ResourceLocation texture) {
        this.shader = shader;
        this.texture = texture;
    }

    private void build() {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        VeilRenderSystem.setShader(this.shader);
        this.mesh = new VertexBuffer(VertexBuffer.Usage.STATIC);
        bufferbuilder.begin(VertexFormat.Mode.QUADS, VeilVertexFormat.SKINNED_MESH);
        for (Map.Entry<Integer, SkinnedMesh> meshEntry : this.boneToMesh.entrySet()) {
            meshEntry.getValue().build(bufferbuilder, meshEntry.getKey());
        }
        BufferBuilder.RenderedBuffer renderedBuffer = bufferbuilder.end();
        this.mesh.bind();
        this.mesh.upload(renderedBuffer);
        VertexBuffer.unbind();
    }

    public void render(PoseStack stack, Skeleton skeleton) {
        this.mesh.drawWithShader(stack.last().pose(), RenderSystem.getProjectionMatrix(), VeilRenderSystem.setShader(this.shader).toShaderInstance());
    }

    public static class Builder {
        private final Skeleton skeleton;
        private final Skin skin;

        public Builder(Skeleton skeleton, ResourceLocation shader, ResourceLocation texture) {
            this.skeleton = skeleton;
            this.skin = new Skin(shader, texture);
        }

        public Builder assignMesh(String boneName, SkinnedMesh mesh) {
            if (!this.skeleton.nameToId.containsKey(boneName)) {
                Veil.LOGGER.error("Cannot find bone of name {} in skeleton! Mesh not assigned.", (Object)boneName);
            } else {
                this.skin.boneToMesh.put(this.skeleton.nameToId.get(boneName), mesh);
            }
            return this;
        }

        public Skin build() {
            return this.skin;
        }
    }
}

