/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.resource;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_3268.class})
public abstract class VanillaPackResourcesMixin
implements PackResourcesExtension {
    @Shadow
    @Final
    private Map<class_3264, List<Path>> field_40003;
    @Shadow
    @Final
    private Set<String> field_14193;

    @Override
    public void veil$listResources(final PackResourcesExtension.PackResourceConsumer consumer) {
        for (Map.Entry<class_3264, List<Path>> entry : this.field_40003.entrySet()) {
            final class_3264 type = entry.getKey();
            for (Path basePath : entry.getValue()) {
                final String separator = basePath.getFileSystem().getSeparator();
                for (final String namespace : this.field_14193) {
                    final Path nsPath = basePath.resolve(namespace);
                    try {
                        Files.walkFileTree(nsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                                if (type == class_3264.field_14188 && dir.endsWith(class_3264.field_14190.method_14413())) {
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                if (type == class_3264.field_14190 && dir.endsWith(class_3264.field_14188.method_14413())) {
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                String filename = nsPath.relativize(file).toString().replace(separator, "/");
                                class_2960 name = class_2960.method_43902((String)namespace, (String)filename);
                                if (name != null) {
                                    consumer.accept(type, name, nsPath, file, null);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                                if (file.endsWith("/data/realms")) {
                                    return FileVisitResult.CONTINUE;
                                }
                                return super.visitFileFailed(file, exc);
                            }
                        });
                    }
                    catch (IOException e) {
                        Veil.LOGGER.warn("findResources in vanilla {} failed!", (Object)namespace, (Object)e);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public class_7367<InputStream> veil$getIcon() {
        return null;
    }
}

