/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.apache.commons.io.IOUtils;

public class ShaderImportProcessor
implements ShaderPreProcessor {
    private static final String INCLUDE_KEY = "#include ";
    private final class_5912 resourceProvider;
    private final Set<class_2960> addedImports;
    private final Map<class_2960, String> imports;
    private final List<class_2960> importOrder;
    private int layer;

    public ShaderImportProcessor(class_5912 resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.addedImports = new HashSet<class_2960>();
        this.imports = new HashMap<class_2960, String>();
        this.importOrder = new ArrayList<class_2960>();
        this.layer = 0;
    }

    @Override
    public void prepare() {
        this.addedImports.clear();
    }

    @Override
    public String modify(ShaderPreProcessor.Context context, String source) throws IOException {
        List<String> inputLines = source.lines().toList();
        LinkedList<String> output = new LinkedList<String>();
        for (String line : inputLines) {
            if (!line.startsWith(INCLUDE_KEY)) {
                output.add(line);
                continue;
            }
            try {
                String trimmedImport = line.substring(INCLUDE_KEY.length()).trim();
                class_2960 include = new class_2960(trimmedImport);
                context.addInclude(include);
                if (!this.addedImports.add(include)) continue;
                try {
                    String importString;
                    if (!this.imports.containsKey(include)) {
                        this.imports.put(include, this.loadImport(include));
                        this.importOrder.add(include);
                    }
                    if ((importString = this.imports.get(include)) == null) {
                        throw new IOException("Import previously failed to load");
                    }
                    long lineNumber = String.join((CharSequence)"\n", output).lines().count();
                    int sourceNumber = this.importOrder.indexOf(include) + 1;
                    ++this.layer;
                    output.add(context.modify(include, importString));
                    --this.layer;
                }
                catch (Exception e) {
                    throw new IOException("Failed to add import: " + line, e);
                }
            }
            catch (class_151 e) {
                throw new IOException("Invalid import: " + line, e);
            }
        }
        return String.join((CharSequence)"\n", output);
    }

    private String loadImport(class_2960 source) throws IOException {
        class_3298 resource = this.resourceProvider.getResourceOrThrow(ShaderManager.INCLUDE_LISTER.method_45112(source));
        try (BufferedReader reader = resource.method_43039();){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }
}

