package foundry.veil.api.client.render.rendertype.layer;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public class DynamicRenderTypeManager extends class_4080<Map<class_2960, byte[]>> {

    private static final class_7654 CONVERTER = class_7654.method_45114("pinwheel/rendertypes");

    @Override
    protected @NotNull Map<class_2960, byte[]> method_18789(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        Map<class_2960, byte[]> data = new HashMap<>();

        Map<class_2960, class_3298> resources = CONVERTER.method_45113(resourceManager);
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 location = entry.getKey();
            class_2960 id = CONVERTER.method_45115(location);

            try (InputStream stream = entry.getValue().method_14482()) {
                data.put(id, stream.readAllBytes());
            } catch (Exception e) {
                Veil.LOGGER.error("Couldn't read data file {} from {}", id, location, e);
            }
        }

        return data;
    }

    @Override
    protected void apply(Map<class_2960, byte[]> fileData, class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, class_1921> renderTypes = new HashMap<>();
        int injections = 0;

        for (Map.Entry<class_2960, byte[]> entry : fileData.entrySet()) {
            class_2960 id = entry.getKey();

            try (Reader reader = new InputStreamReader(new ByteArrayInputStream(entry.getValue()))) {
                JsonElement element = JsonParser.parseReader(reader);
                DataResult<CompositeRenderTypeData> result = CompositeRenderTypeData.CODEC.parse(JsonOps.INSTANCE, element);

                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(result.error().get().message());
                }

                CompositeRenderTypeData data = result.result().orElseThrow();
                if (data.inject() != null) {
                    // TODO inject
                    injections++;
                    continue;
                }

                if (renderTypes.put(id, data.createRenderType(id.toString())) != null) {
                    throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                }
            } catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", id, CONVERTER.method_45112(id), e);
            }
        }
        Veil.LOGGER.info("Loaded {} render types", renderTypes.size() + injections);
    }
}
