/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node.branch;

import foundry.veil.impl.glsl.node.GlslNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GlslSwitchNode
implements GlslNode {
    private GlslNode condition;
    private final List<GlslNode> branches;

    public GlslSwitchNode(GlslNode condition, Collection<GlslNode> branches) {
        this.condition = condition;
        this.branches = new ArrayList<GlslNode>(branches);
    }

    public GlslNode getCondition() {
        return this.condition;
    }

    public List<GlslNode> getBranches() {
        return this.branches;
    }

    public GlslSwitchNode setCondition(GlslNode condition) {
        this.condition = condition;
        return this;
    }

    public GlslSwitchNode setBranches(Collection<GlslNode> branches) {
        this.branches.clear();
        this.branches.addAll(branches);
        return this;
    }

    public GlslSwitchNode setBranches(GlslNode ... branches) {
        this.branches.clear();
        this.branches.addAll(Arrays.asList(branches));
        return this;
    }

    public String toString() {
        return "GlslSwitchNode{condition=" + this.condition + ", branches=" + this.branches + "}";
    }

    @Override
    public String getSourceString() {
        StringBuilder builder = new StringBuilder("switch(");
        builder.append(this.condition.getSourceString()).append(") {");
        for (GlslNode branch : this.branches) {
            builder.append('\t').append(branch.getSourceString()).append('\n');
        }
        builder.append('}');
        return builder.toString();
    }
}

