/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.google.common.collect.ImmutableList;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.ext.LevelRendererBlockLayerExtension;
import foundry.veil.fabric.event.FabricVeilRenderLevelStageEvent;
import foundry.veil.mixin.accessor.RenderBuffersAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class FabricRenderTypeStageHandler {
    private static final Map<VeilRenderLevelStageEvent.Stage, Set<class_1921>> STAGE_RENDER_TYPES = new HashMap<VeilRenderLevelStageEvent.Stage, Set<class_1921>>();
    private static Set<class_1921> CUSTOM_BLOCK_LAYERS;
    private static List<class_1921> BLOCK_LAYERS;

    public static void register(@Nullable VeilRenderLevelStageEvent.Stage stage, class_1921 renderType) {
        SortedMap<class_1921, class_287> fixedBuffers = ((RenderBuffersAccessor)class_310.method_1551().method_22940()).getFixedBuffers();
        fixedBuffers.put(renderType, new class_287(renderType.method_22722()));
        if (stage != null) {
            STAGE_RENDER_TYPES.computeIfAbsent(stage, unused -> new HashSet()).add(renderType);
        }
    }

    public static void renderStage(LevelRendererBlockLayerExtension extension, class_3695 profiler, VeilRenderLevelStageEvent.Stage stage, class_761 levelRenderer, class_4597.class_4598 bufferSource, class_4587 poseStack, Matrix4f projectionMatrix, int renderTick, float partialTicks, class_4184 camera, class_4604 frustum) {
        profiler.method_15396(stage.getName());
        ((VeilRenderLevelStageEvent)FabricVeilRenderLevelStageEvent.EVENT.invoker()).onRenderLevelStage(stage, levelRenderer, bufferSource, poseStack, projectionMatrix, renderTick, partialTicks, camera, frustum);
        profiler.method_15407();
        Set<class_1921> stages = STAGE_RENDER_TYPES.get((Object)stage);
        if (stages != null) {
            stages.forEach(renderType -> {
                if (CUSTOM_BLOCK_LAYERS.contains(renderType)) {
                    class_243 pos = camera.method_19326();
                    extension.veil$drawBlockLayer((class_1921)renderType, poseStack, pos.field_1352, pos.field_1351, pos.field_1350, projectionMatrix);
                }
                bufferSource.method_22994(renderType);
            });
        }
    }

    public static List<class_1921> getBlockLayers() {
        return BLOCK_LAYERS;
    }

    public static void setBlockLayers(ImmutableList.Builder<class_1921> blockLayers) {
        CUSTOM_BLOCK_LAYERS = new HashSet<class_1921>((Collection<class_1921>)blockLayers.build());
        blockLayers.addAll((Iterable)class_1921.method_22720());
        BLOCK_LAYERS = blockLayers.build();
    }
}

