/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric.mixin.resource;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModNioResourcePack.class})
public abstract class ModNioResourcePackMixin
implements ModResourcePack,
PackResourcesExtension {
    @Shadow
    @Final
    private List<Path> basePaths;
    @Shadow
    @Final
    private ModMetadata modInfo;
    @Shadow
    @Final
    private Map<PackType, Set<String>> namespaces;

    @Override
    public void veil$listResources(final PackResourcesExtension.PackResourceConsumer consumer) {
        for (final Path basePath : this.basePaths) {
            final String separator = basePath.getFileSystem().getSeparator();
            for (Map.Entry<PackType, Set<String>> entry : this.namespaces.entrySet()) {
                final PackType type = entry.getKey();
                for (final String namespace : entry.getValue()) {
                    final Path nsPath = basePath.resolve(type.getDirectory()).resolve(namespace);
                    if (!Files.exists(nsPath, new LinkOption[0])) continue;
                    try {
                        Files.walkFileTree(nsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                String filename = nsPath.relativize(file).toString().replace(separator, "/");
                                ResourceLocation name = ResourceLocation.tryBuild((String)namespace, (String)filename);
                                if (name != null) {
                                    consumer.accept(type, name, nsPath, file, PackResourcesExtension.findDevPath(basePath, file));
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        Veil.LOGGER.warn("findResources in namespace {}, mod {} failed!", new Object[]{namespace, this.modInfo.getId(), e});
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> veil$getIcon() {
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(this.modInfo.getId()).orElseThrow();
        return this.modInfo.getIconPath(20).flatMap(arg_0 -> ((ModContainer)modContainer).findPath(arg_0)).map(path -> () -> Files.newInputStream(path, new OpenOption[0])).orElse(null);
    }

    @Override
    public Stream<PackResources> veil$listPacks() {
        String id = this.modInfo.getId();
        if (!"fabric-api".equalsIgnoreCase(id) && id.startsWith("fabric") && this.modInfo.containsCustomValue("fabric-api:module-lifecycle")) {
            return Stream.empty();
        }
        return Stream.of(this);
    }
}

