/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import foundry.veil.Veil;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class UIUtils {
    public static void drawHoverText(Tooltippable tooltippable, float pticks, ItemStack stack, PoseStack pStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, Font font, int tooltipTextWidthBonus, int tooltipTextHeightBonus, List<VeilUIItemTooltipDataHolder> items, int desiredX, int desiredY) {
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        List<ClientTooltipComponent> list = UIUtils.gatherTooltipComponents(stack, textLines, stack.getTooltipImage(), mouseX, screenWidth, screenHeight, font, font);
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : textLines) {
            int textLineWidth = font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
            for (int i = 0; i < textLines.size(); ++i) {
                FormattedText textLine = textLines.get(i);
                List wrappedLine = font.getSplitter().splitLines(textLine, tooltipTextWidth, Style.EMPTY);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (FormattedText line : wrappedLine) {
                    int lineWidth = font.width(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((FormattedText)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        UIUtils.drawTooltipRects(pticks, pStack, 400, backgroundColor, borderColorStart, borderColorEnd, font, list, tooltipTextWidth += tooltipTextWidthBonus, n, tooltipX, tooltipY, tooltipHeight += tooltipTextHeightBonus, items);
    }

    private static void drawTooltipRects(float pticks, PoseStack pStack, int z, int backgroundColor, int borderColorStart, int borderColorEnd, Font font, List<ClientTooltipComponent> list, int tooltipTextWidth, int titleLinesCount, int tooltipX, int tooltipY, int tooltipHeight, List<VeilUIItemTooltipDataHolder> items) {
        pStack.pushPose();
        Matrix4f mat = pStack.last().pose();
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        UIUtils.drawGradientRect(mat, z, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        int itemY = tooltipY;
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            if (lineNumber + 1 == titleLinesCount) {
                itemY += 2;
            }
            itemY += 10;
        }
        pStack.pushPose();
        pStack.translate(0.0f, 0.0f, 300.0f);
        if (items != null && !items.isEmpty()) {
            for (VeilUIItemTooltipDataHolder item : items) {
                UIUtils.renderAndDecorateItem(item.getItemStack(), (float)tooltipX + item.getX().apply(Float.valueOf(pticks)).floatValue(), (float)itemY + item.getY().apply(Float.valueOf(pticks)).floatValue());
                UIUtils.drawTexturedRect(pStack.last().pose(), z + 100, (float)tooltipX + item.getX().apply(Float.valueOf(pticks)).floatValue(), (float)itemY + item.getY().apply(Float.valueOf(pticks)).floatValue(), 16.0f, 16.0f, 0.0f, 0.0f, 0.0f, 0.0f, 16, 16, Veil.veilPath("textures/gui/item_shadow.png"));
            }
        }
        pStack.popPose();
        MultiBufferSource.BufferSource renderType = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        pStack.translate(0.0, 0.0, (double)z);
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            ClientTooltipComponent line = list.get(lineNumber);
            if (line != null) {
                line.renderText(font, tooltipX, tooltipY, mat, renderType);
            }
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.endBatch();
        pStack.popPose();
        RenderSystem.enableDepthTest();
    }

    public static void renderAndDecorateItem(ItemStack $$0, float $$1, float $$2) {
        UIUtils.tryRenderGuiItem((LivingEntity)Minecraft.getInstance().player, $$0, $$1, $$2, 0);
    }

    public static void tryRenderGuiItem(@Nullable LivingEntity $$0, ItemStack $$1, float $$2, float $$3, int $$4) {
        UIUtils.tryRenderGuiItem($$0, $$1, $$2, $$3, $$4, 0.0f);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, @Nullable Font forcedFont, Font fallbackFont) {
        Font font = forcedFont != null ? forcedFont : fallbackFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        int tooltipTextWidth = elements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return elements.stream().flatMap(either -> (Stream)either.map(text -> font.split(text, tooltipTextWidthF).stream().map(ClientTooltipComponent::create), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
        }
        return elements.stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.create((FormattedCharSequence)(text instanceof Component ? ((Component)text).getVisualOrderText() : Language.getInstance().getVisualOrder(text))), ClientTooltipComponent::create)).toList();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.vertex(mat, (float)right, (float)top, (float)zLevel).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        buffer.vertex(mat, (float)left, (float)top, (float)zLevel).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        buffer.vertex(mat, (float)left, (float)bottom, (float)zLevel).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        buffer.vertex(mat, (float)right, (float)bottom, (float)zLevel).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        tessellator.end();
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRect(Matrix4f mat, int zLevel, float x, float y, float width, float height, float u, float v, float uWidth, float vHeight, int textureWidth, int textureHeight, ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.vertex(mat, x, y + height, (float)zLevel).uv(u * f, (v + vHeight) * f1).endVertex();
        buffer.vertex(mat, x + width, y + height, (float)zLevel).uv((u + uWidth) * f, (v + vHeight) * f1).endVertex();
        buffer.vertex(mat, x + width, y, (float)zLevel).uv((u + uWidth) * f, v * f1).endVertex();
        buffer.vertex(mat, x, y, (float)zLevel).uv(u * f, v * f1).endVertex();
        tessellator.end();
    }

    public static void tryRenderGuiItem(LivingEntity $$0, ItemStack $$1, float $$2, float $$3, int $$4, float $$5) {
    }

    public static void renderGuiItem(ItemStack stack, float x, float y, BakedModel bakedModel) {
        boolean $$7;
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack $$4 = RenderSystem.getModelViewStack();
        $$4.pushPose();
        $$4.translate(8.0, 8.0, 0.0);
        $$4.scale(1.0f, -1.0f, 1.0f);
        $$4.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack $$5 = new PoseStack();
        MultiBufferSource.BufferSource $$6 = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = $$7 = !bakedModel.usesBlockLight();
        if ($$7) {
            Lighting.setupForFlatItems();
        } else {
            Lighting.setupFor3DItems();
        }
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, $$5, (MultiBufferSource)$$6, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        $$6.endBatch();
        RenderSystem.enableDepthTest();
        if ($$7) {
            Lighting.setupFor3DItems();
        }
        $$4.popPose();
        RenderSystem.applyModelViewMatrix();
    }
}

