/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.VeilShaderLimits;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.ext.VertexBufferExtension;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.client.render.pipeline.VeilUniformBlockState;
import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GLCapabilities;

public final class VeilRenderSystem {
    private static final Executor RENDER_THREAD_EXECUTOR = task -> {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(task::run);
        } else {
            task.run();
        }
    };
    private static final Set<ResourceLocation> ERRORED_SHADERS = new HashSet<ResourceLocation>();
    private static final VeilUniformBlockState UNIFORM_BLOCK_STATE = new VeilUniformBlockState();
    private static final BooleanSupplier COMPUTE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL43 || caps.GL_ARB_compute_shader);
    private static final BooleanSupplier ATOMIC_COUNTER_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL42 || caps.GL_ARB_shader_atomic_counters);
    private static final BooleanSupplier TRANSFORM_FEEDBACK_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL40 || caps.GL_ARB_transform_feedback3);
    private static final BooleanSupplier TEXTURE_MULTIBIND_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.glBindTextures != 0L);
    private static final BooleanSupplier SPARSE_BUFFERS_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.GL_ARB_sparse_buffer);
    private static final BooleanSupplier DIRECT_STATE_ACCESS_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL45 || caps.GL_ARB_direct_state_access);
    private static final IntSupplier MAX_COMBINED_TEXTURE_IMAGE_UNITS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35661));
    private static final IntSupplier MAX_COLOR_ATTACHMENTS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)36063));
    private static final IntSupplier MAX_SAMPLES = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)36183));
    private static final IntSupplier MAX_TRANSFORM_FEEDBACK_BUFFERS = VeilRenderSystem.glGetter(() -> TRANSFORM_FEEDBACK_SUPPORTED.getAsBoolean() ? GL11C.glGetInteger((int)36464) : 0);
    private static final IntSupplier MAX_UNIFORM_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35375));
    private static final IntSupplier MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)37596));
    private static final IntSupplier MAX_SHADER_STORAGE_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)37085));
    private static final IntSupplier MAX_ARRAY_TEXTURE_LAYERS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35071));
    private static final Supplier<VeilShaderLimits> VERTEX_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)35658), GL11C.glGetInteger((int)35371), GL11C.glGetInteger((int)34921) * 4, GL11C.glGetInteger((int)37154), GL11C.glGetInteger((int)35660), 37066, 37586, 37580, 37078);
    });
    private static final Supplier<VeilShaderLimits> GL_TESS_CONTROL_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)36479), GL11C.glGetInteger((int)36489), GL11C.glGetInteger((int)34924), GL11C.glGetInteger((int)36483), GL11C.glGetInteger((int)36481), 37067, 37587, 37581, 37080);
    });
    private static final Supplier<VeilShaderLimits> GL_TESS_EVALUATION_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)36480), GL11C.glGetInteger((int)36490), GL11C.glGetInteger((int)34925), GL11C.glGetInteger((int)36486), GL11C.glGetInteger((int)36482), 37068, 37588, 37582, 37081);
    });
    private static final Supplier<VeilShaderLimits> GL_GEOMETRY_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)36319), GL11C.glGetInteger((int)35372), GL11C.glGetInteger((int)37155), GL11C.glGetInteger((int)37156), GL11C.glGetInteger((int)35881), 37069, 37589, 37583, 37079);
    });
    private static final Supplier<VeilShaderLimits> GL_FRAGMENT_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)35657), GL11C.glGetInteger((int)35373), GL11C.glGetInteger((int)37157), GL11C.glGetInteger((int)34852) * 4, GL11C.glGetInteger((int)34930), 37070, 37590, 37584, 37082);
    });
    private static final Supplier<VeilShaderLimits> GL_COMPUTE_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)33379), GL11C.glGetInteger((int)37307), 0, 0, GL11C.glGetInteger((int)37308), 37309, 33381, 33380, 37083);
    });
    private static final Supplier<Vector2ic> MAX_FRAMEBUFFER_SIZE = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!GL.getCapabilities().OpenGL43) {
            return new Vector2i(Integer.MAX_VALUE);
        }
        int width = GL11C.glGetInteger((int)37653);
        int height = GL11C.glGetInteger((int)37654);
        return new Vector2i(width, height);
    });
    private static final Supplier<Vector3ic> MAX_COMPUTE_WORK_GROUP_COUNT = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!COMPUTE_SUPPORTED.getAsBoolean()) {
            return new Vector3i();
        }
        int width = GL43C.glGetIntegeri((int)37310, (int)0);
        int height = GL43C.glGetIntegeri((int)37310, (int)1);
        int depth = GL43C.glGetIntegeri((int)37310, (int)2);
        return new Vector3i(width, height, depth);
    });
    private static final Supplier<Vector3ic> MAX_COMPUTE_WORK_GROUP_SIZE = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!COMPUTE_SUPPORTED.getAsBoolean()) {
            return new Vector3i();
        }
        int width = GL43C.glGetIntegeri((int)37311, (int)0);
        int height = GL43C.glGetIntegeri((int)37311, (int)1);
        int depth = GL43C.glGetIntegeri((int)37311, (int)2);
        return new Vector3i(width, height, depth);
    });
    private static final IntSupplier MAX_COMPUTE_WORK_GROUP_INVOCATIONS = VeilRenderSystem.glGetter(() -> COMPUTE_SUPPORTED.getAsBoolean() ? GL11C.glGetInteger((int)37099) : 0);
    private static final Vector3f LIGHT0_POSITION = new Vector3f();
    private static final Vector3f LIGHT1_POSITION = new Vector3f();
    private static VeilRenderer renderer;
    private static ResourceLocation shaderLocation;
    private static VertexBuffer vbo;

    private VeilRenderSystem() {
    }

    private static BooleanSupplier glCapability(final Function<GLCapabilities, Boolean> delegate) {
        return new BooleanSupplier(){
            private boolean value;
            private boolean initialized;

            @Override
            public boolean getAsBoolean() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (!this.initialized) {
                    this.initialized = true;
                    this.value = (Boolean)delegate.apply(GL.getCapabilities());
                    return this.value;
                }
                return this.value;
            }
        };
    }

    private static IntSupplier glGetter(final IntSupplier delegate) {
        return new IntSupplier(){
            private int value = Integer.MAX_VALUE;

            @Override
            public int getAsInt() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (this.value == Integer.MAX_VALUE) {
                    this.value = delegate.getAsInt();
                    return this.value;
                }
                return this.value;
            }
        };
    }

    private static <T> Supplier<T> glGetter(final Supplier<T> delegate) {
        return new Supplier<T>(){
            private T value = null;

            @Override
            public T get() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (this.value == null) {
                    this.value = delegate.get();
                    return this.value;
                }
                return this.value;
            }
        };
    }

    @ApiStatus.Internal
    public static void init() {
        Minecraft client = Minecraft.getInstance();
        ResourceManager resourceManager = client.getResourceManager();
        if (!(resourceManager instanceof ReloadableResourceManager)) {
            throw new IllegalStateException("Client resource manager is " + client.getResourceManager().getClass());
        }
        ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
        renderer = new VeilRenderer(resourceManager2);
        VeilImGuiImpl.init(client.getWindow().getWindow());
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        bufferBuilder.vertex(-1.0, 1.0, 0.0).endVertex();
        bufferBuilder.vertex(-1.0, -1.0, 0.0).endVertex();
        bufferBuilder.vertex(1.0, 1.0, 0.0).endVertex();
        bufferBuilder.vertex(1.0, -1.0, 0.0).endVertex();
        vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vbo.bind();
        vbo.upload(bufferBuilder.end());
        VertexBuffer.unbind();
    }

    private static void invalidateTextures(int first, int count) {
        int invalidCount = Math.min(12 - first, count);
        for (int i = first; i < invalidCount; ++i) {
            GlStateManager.TEXTURES[i].binding = -1;
        }
    }

    public static void bindTextures(int first, IntBuffer textures) {
        VeilRenderSystem.invalidateTextures(first, textures.limit());
        GL44C.glBindTextures((int)first, (IntBuffer)textures);
    }

    public static void bindTextures(int first, int ... textures) {
        VeilRenderSystem.invalidateTextures(first, textures.length);
        GL44C.glBindTextures((int)first, (int[])textures);
    }

    public static void drawScreenQuad() {
        vbo.bind();
        vbo.draw();
        VertexBuffer.unbind();
    }

    @Nullable
    public static ShaderProgram setShader(ResourceLocation shader) {
        ShaderManager shaderManager = renderer.getShaderManager();
        shaderLocation = shader;
        return VeilRenderSystem.setShader(() -> shaderManager.getShader(shader));
    }

    @Nullable
    public static ShaderProgram setShader(@Nullable ShaderProgram shader) {
        shaderLocation = shader != null ? shader.getId() : null;
        return VeilRenderSystem.setShader(() -> shader);
    }

    @Nullable
    public static ShaderProgram setShader(Supplier<ShaderProgram> shader) {
        RenderSystem.setShader(() -> {
            ShaderProgram program = (ShaderProgram)shader.get();
            return program != null ? program.toShaderInstance() : null;
        });
        ShaderProgram value = VeilRenderSystem.getShader();
        if (value == null) {
            VeilRenderSystem.throwShaderError();
        }
        return value;
    }

    @ApiStatus.Internal
    public static void finalizeShaderCompilation() {
        ERRORED_SHADERS.clear();
        UNIFORM_BLOCK_STATE.queueUpload();
    }

    public static void throwShaderError() {
        if (shaderLocation != null && ERRORED_SHADERS.add(shaderLocation)) {
            Veil.LOGGER.error("Failed to apply shader: {}", (Object)shaderLocation);
        }
    }

    public static void drawInstanced(VertexBuffer vbo, int instances) {
        ((VertexBufferExtension)vbo).veil$drawInstanced(instances);
    }

    public static void drawIndirect(VertexBuffer vbo, long indirect, int drawCount, int stride) {
        ((VertexBufferExtension)vbo).veil$drawIndirect(indirect, drawCount, stride);
    }

    public static void printGlErrors(@Nullable String glCall) {
        int error;
        while ((error = GlStateManager._getError()) != 0) {
            if (glCall != null) {
                Veil.LOGGER.error("[OpenGL Error] '{}' 0x{}", (Object)glCall, (Object)Integer.toHexString(error).toUpperCase(Locale.ROOT));
                continue;
            }
            Veil.LOGGER.error("[OpenGL Error] 0x{}", (Object)Integer.toHexString(error).toUpperCase(Locale.ROOT));
        }
    }

    public static int getIndexCount(VertexBuffer vbo) {
        return ((VertexBufferExtension)vbo).veil$getIndexCount();
    }

    public static boolean computeSupported() {
        return COMPUTE_SUPPORTED.getAsBoolean();
    }

    public static boolean atomicCounterSupported() {
        return ATOMIC_COUNTER_SUPPORTED.getAsBoolean();
    }

    public static boolean transformFeedbackSupported() {
        return TRANSFORM_FEEDBACK_SUPPORTED.getAsBoolean();
    }

    public static boolean textureMultibindSupported() {
        return TEXTURE_MULTIBIND_SUPPORTED.getAsBoolean();
    }

    public static boolean sparseBuffersSupported() {
        return SPARSE_BUFFERS_SUPPORTED.getAsBoolean();
    }

    public static boolean directStateAccessSupported() {
        return DIRECT_STATE_ACCESS_SUPPORTED.getAsBoolean();
    }

    public static int maxCombinedTextureUnits() {
        return MAX_COMBINED_TEXTURE_IMAGE_UNITS.getAsInt();
    }

    public static int maxColorAttachments() {
        return MAX_COLOR_ATTACHMENTS.getAsInt();
    }

    public static int maxSamples() {
        return MAX_SAMPLES.getAsInt();
    }

    public static int maxTargetBindings(int target) {
        return switch (target) {
            case 35982 -> VeilRenderSystem.maxTransformFeedbackBindings();
            case 35345 -> VeilRenderSystem.maxUniformBuffersBindings();
            case 37568 -> VeilRenderSystem.maxAtomicCounterBufferBindings();
            case 37074 -> VeilRenderSystem.maxShaderStorageBufferBindings();
            default -> throw new IllegalArgumentException("Invalid Target: 0x" + Integer.toHexString(target).toUpperCase(Locale.ROOT));
        };
    }

    public static VeilShaderLimits shaderLimits(int shader) {
        return switch (shader) {
            case 35633 -> VERTEX_SHADER_LIMITS.get();
            case 36488 -> GL_TESS_CONTROL_SHADER_LIMITS.get();
            case 36487 -> GL_TESS_EVALUATION_SHADER_LIMITS.get();
            case 36313 -> GL_GEOMETRY_SHADER_LIMITS.get();
            case 35632 -> GL_FRAGMENT_SHADER_LIMITS.get();
            case 37305 -> GL_COMPUTE_SHADER_LIMITS.get();
            default -> throw new IllegalArgumentException("Invalid Shader Type: 0x" + Integer.toHexString(shader).toUpperCase(Locale.ROOT));
        };
    }

    public static int maxTransformFeedbackBindings() {
        return MAX_TRANSFORM_FEEDBACK_BUFFERS.getAsInt();
    }

    public static int maxUniformBuffersBindings() {
        return MAX_UNIFORM_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxAtomicCounterBufferBindings() {
        return MAX_ATOMIC_COUNTER_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxShaderStorageBufferBindings() {
        return MAX_SHADER_STORAGE_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxArrayTextureLayers() {
        return MAX_ARRAY_TEXTURE_LAYERS.getAsInt();
    }

    public static int maxFramebufferWidth() {
        return MAX_FRAMEBUFFER_SIZE.get().x();
    }

    public static int maxFramebufferHeight() {
        return MAX_FRAMEBUFFER_SIZE.get().y();
    }

    public static int maxComputeWorkGroupCountX() {
        return MAX_COMPUTE_WORK_GROUP_COUNT.get().y();
    }

    public static int maxComputeWorkGroupCountY() {
        return MAX_COMPUTE_WORK_GROUP_COUNT.get().y();
    }

    public static int maxComputeWorkGroupCountZ() {
        return MAX_COMPUTE_WORK_GROUP_COUNT.get().y();
    }

    public static int maxComputeWorkGroupSizeX() {
        return MAX_COMPUTE_WORK_GROUP_SIZE.get().y();
    }

    public static int maxComputeWorkGroupSizeY() {
        return MAX_COMPUTE_WORK_GROUP_SIZE.get().y();
    }

    public static int maxComputeWorkGroupSizeZ() {
        return MAX_COMPUTE_WORK_GROUP_SIZE.get().y();
    }

    public static int maxComputeWorkGroupInvocations() {
        return MAX_COMPUTE_WORK_GROUP_INVOCATIONS.getAsInt();
    }

    public static void bind(ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.bind(block);
    }

    public static void bind(CharSequence name, ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.bind(name, block);
    }

    public static void unbind(ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.unbind(block);
    }

    public static void bindVertexArray(int vao) {
        BufferUploader.invalidate();
        GlStateManager._glBindVertexArray((int)vao);
    }

    public static VeilRenderer renderer() {
        return renderer;
    }

    public static Executor renderThreadExecutor() {
        return RENDER_THREAD_EXECUTOR;
    }

    @Nullable
    public static ShaderProgram getShader() {
        ShaderProgram shaderProgram;
        ShaderInstance shader = RenderSystem.getShader();
        if (shader instanceof ShaderProgramImpl.Wrapper) {
            ShaderProgramImpl.Wrapper wrapper = (ShaderProgramImpl.Wrapper)shader;
            shaderProgram = wrapper.program();
        } else {
            shaderProgram = null;
        }
        return shaderProgram;
    }

    public static Vector3fc getLight0Position() {
        return LIGHT0_POSITION;
    }

    public static Vector3fc getLight1Position() {
        return LIGHT1_POSITION;
    }

    @ApiStatus.Internal
    public static void beginFrame() {
        VeilImGuiImpl.get().beginFrame();
    }

    @ApiStatus.Internal
    public static void endFrame() {
        VeilImGuiImpl.get().endFrame();
        renderer.getFramebufferManager().clear();
        UNIFORM_BLOCK_STATE.clear();
    }

    @ApiStatus.Internal
    public static void shaderUpdate() {
        shaderLocation = null;
    }

    @ApiStatus.Internal
    public static void resize(int width, int height) {
        if (renderer != null) {
            renderer.getFramebufferManager().resizeFramebuffers(width, height);
        }
    }

    @ApiStatus.Internal
    public static void close() {
        VeilImGuiImpl.get().free();
        VeilOpenCL.tryFree();
        if (renderer != null) {
            renderer.free();
        }
        vbo.close();
    }

    @ApiStatus.Internal
    public static void renderPost() {
        renderer.getPostProcessingManager().runPipeline();
    }

    @ApiStatus.Internal
    public static void setShaderLights(Vector3fc light0, Vector3fc light1) {
        LIGHT0_POSITION.set(light0);
        LIGHT1_POSITION.set(light1);
    }
}

