/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class CodecUtil {
    public static final Codec<Vector2fc> VECTOR2F_CODEC = Codec.FLOAT.listOf().flatXmap(list -> CodecUtil.check(3, list), list -> CodecUtil.check(2, list)).xmap(list -> new Vector2f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue()), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y())));
    public static final Codec<Vector3fc> VECTOR3F_CODEC = Codec.FLOAT.listOf().flatXmap(list -> CodecUtil.check(3, list), list -> CodecUtil.check(3, list)).xmap(list -> new Vector3f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue()), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y()), Float.valueOf(vector.z())));
    public static final Codec<Vector4fc> VECTOR4F_CODEC = Codec.FLOAT.listOf().flatXmap(list -> CodecUtil.check(4, list), list -> CodecUtil.check(4, list)).xmap(list -> new Vector4f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue()), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y()), Float.valueOf(vector.z()), Float.valueOf(vector.w())));
    public static final Codec<Vector3dc> VECTOR3D_CODEC = Codec.DOUBLE.listOf().flatXmap(list -> CodecUtil.check(3, list), list -> CodecUtil.check(3, list)).xmap(list -> new Vector3d(((Double)list.get(0)).doubleValue(), ((Double)list.get(1)).doubleValue(), ((Double)list.get(2)).doubleValue()), vector -> List.of(Double.valueOf(vector.x()), Double.valueOf(vector.y()), Double.valueOf(vector.z())));

    private static <T> DataResult<List<T>> check(int size, List<T> list) {
        if (list.size() != size) {
            return DataResult.error(() -> "Vector" + size + "f must have " + size + " elements!");
        }
        return DataResult.success(list);
    }

    public static <T> Codec<List<T>> singleOrList(Codec<T> codec) {
        return Codec.either((Codec)codec.flatComapMap(List::of, l -> l.size() == 1 ? DataResult.success(l.get(0)) : DataResult.error(() -> "List must have exactly one element.")), (Codec)ExtraCodecs.nonEmptyList((Codec)codec.listOf())).xmap(e -> (List)e.map(Function.identity(), Function.identity()), l -> l.size() == 1 ? Either.left((Object)l) : Either.right((Object)l));
    }

    public static <T> Codec<T> registryOrLegacyCodec(Registry<T> registry) {
        Codec legacyCodec = Codec.STRING.comapFlatMap(name -> ResourceLocation.read((String)("veil:" + name.toLowerCase(Locale.ROOT))), ResourceLocation::toString).flatXmap(loc -> Optional.ofNullable(registry.get(loc)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + registry.key() + ": " + loc)), object -> registry.getResourceKey(object).map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + registry.key() + ":" + object)));
        return Codec.either((Codec)registry.byNameCodec(), (Codec)legacyCodec).xmap(e -> e.map(Function.identity(), Function.identity()), Either::left);
    }
}

