/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.data.EmitterShapeSettings;
import foundry.veil.api.quasar.data.ParticleEmitterData;
import foundry.veil.api.quasar.data.ParticleSettings;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.resource.VeilDynamicRegistry;
import java.util.List;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;

public final class QuasarParticles {
    public static final ResourceKey<Registry<ParticleModuleData>> INIT_MODULES = QuasarParticles.createRegistryKey("quasar/modules/init");
    public static final ResourceKey<Registry<ParticleModuleData>> UPDATE_MODULES = QuasarParticles.createRegistryKey("quasar/modules/update");
    public static final ResourceKey<Registry<ParticleModuleData>> RENDER_MODULES = QuasarParticles.createRegistryKey("quasar/modules/render");
    public static final ResourceKey<Registry<QuasarParticleData>> PARTICLE_DATA = QuasarParticles.createRegistryKey("quasar/modules/particle_data");
    public static final ResourceKey<Registry<ParticleSettings>> PARTICLE_SETTINGS = QuasarParticles.createRegistryKey("quasar/modules/emitter/particle");
    public static final ResourceKey<Registry<EmitterShapeSettings>> EMITTER_SHAPE_SETTINGS = QuasarParticles.createRegistryKey("quasar/modules/emitter/shape");
    public static final ResourceKey<Registry<ParticleEmitterData>> EMITTER = QuasarParticles.createRegistryKey("quasar/emitters");
    private static final SuggestionProvider<?> EMITTER_SUGGESTION_PROVIDER = (unused, builder) -> QuasarParticles.registryAccess().registry(EMITTER).map(registry -> SharedSuggestionProvider.suggestResource((Iterable)registry.keySet(), (SuggestionsBuilder)builder)).orElseGet(Suggestions::empty);
    private static final List<RegistryDataLoader.RegistryData<?>> REGISTRIES = List.of(new RegistryDataLoader.RegistryData(INIT_MODULES, ParticleModuleData.INIT_DIRECT_CODEC), new RegistryDataLoader.RegistryData(UPDATE_MODULES, ParticleModuleData.UPDATE_DIRECT_CODEC), new RegistryDataLoader.RegistryData(RENDER_MODULES, ParticleModuleData.RENDER_DIRECT_CODEC), new RegistryDataLoader.RegistryData(PARTICLE_DATA, QuasarParticleData.DIRECT_CODEC), new RegistryDataLoader.RegistryData(PARTICLE_SETTINGS, ParticleSettings.DIRECT_CODEC), new RegistryDataLoader.RegistryData(EMITTER_SHAPE_SETTINGS, EmitterShapeSettings.DIRECT_CODEC), new RegistryDataLoader.RegistryData(EMITTER, ParticleEmitterData.DIRECT_CODEC));
    private static RegistryAccess registryAccess = RegistryAccess.EMPTY;

    private QuasarParticles() {
    }

    private static <T> ResourceKey<Registry<T>> createRegistryKey(String name) {
        return ResourceKey.createRegistryKey((ResourceLocation)Veil.veilPath(name));
    }

    public static <T extends SharedSuggestionProvider> SuggestionProvider<T> emitterSuggestionProvider() {
        return EMITTER_SUGGESTION_PROVIDER;
    }

    public static RegistryAccess registryAccess() {
        return registryAccess;
    }

    @ApiStatus.Internal
    public static class Reloader
    extends SimplePreparableReloadListener<VeilDynamicRegistry.Data> {
        protected VeilDynamicRegistry.Data prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            return VeilDynamicRegistry.loadRegistries(resourceManager, REGISTRIES);
        }

        protected void apply(VeilDynamicRegistry.Data preparations, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            registryAccess = preparations.registryAccess();
            ParticleEmitter.clearErrors();
            String msg = VeilDynamicRegistry.printErrors(preparations.errors());
            if (msg != null) {
                Veil.LOGGER.error("Quasar registry loading errors:{}", (Object)msg);
            }
            Veil.LOGGER.info("Loaded {} quasar particles", (Object)registryAccess.registryOrThrow(EMITTER).size());
            VeilRenderSystem.renderer().getParticleManager().clear();
        }

        public String getName() {
            return QuasarParticles.class.getSimpleName();
        }
    }
}

