/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public record ProgramDefinition(@Nullable ShaderSource vertex, @Nullable ShaderSource tesselationControl, @Nullable ShaderSource tesselationEvaluation, @Nullable ShaderSource geometry, @Nullable ShaderSource fragment, @Nullable ShaderSource compute, String[] definitions, Map<String, String> definitionDefaults, Map<String, ShaderTextureSource> textures, Int2ObjectMap<ShaderSource> shaders) {

    public record ShaderSource(class_2960 location, SourceType sourceType) {
    }

    public static class Deserializer
    implements JsonDeserializer<ProgramDefinition> {
        @Nullable
        private static ShaderSource deserializeSource(JsonObject json, String name, JsonDeserializationContext context) {
            JsonElement element = json.get(name);
            if (element == null) {
                return null;
            }
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                class_2960 path = (class_2960)context.deserialize(object.get("path"), class_2960.class);
                SourceType sourceType = json.has("type") ? SourceType.byName(class_3518.method_15265((JsonObject)object, (String)"type")) : SourceType.GLSL;
                return path != null ? new ShaderSource(path, sourceType) : null;
            }
            return new ShaderSource((class_2960)context.deserialize(element, class_2960.class), SourceType.GLSL);
        }

        private String[] deserializeDefinitions(JsonArray json, Map<String, String> defaults) throws JsonParseException {
            ArrayList<String> definitions = new ArrayList<String>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JsonElement element = json.get(i);
                if (element.isJsonPrimitive()) {
                    definitions.add(element.getAsJsonPrimitive().getAsString());
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject definitionJson = element.getAsJsonObject();
                    Set entrySet = definitionJson.entrySet();
                    if (entrySet.size() != 1) {
                        throw new JsonSyntaxException("Expected definitions[" + i + "] to have one element, had " + entrySet.size());
                    }
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)entrySet);
                    definitions.add((String)entry.getKey());
                    defaults.put((String)entry.getKey(), class_3518.method_15287((JsonElement)((JsonElement)entry.getValue()), (String)("definitions[" + i + "]")));
                    continue;
                }
                throw new JsonSyntaxException("Expected definitions[" + i + "] to be a JsonPrimitive or Object, was " + class_3518.method_15266((JsonElement)element));
            }
            return (String[])definitions.toArray(String[]::new);
        }

        private Map<String, ShaderTextureSource> deserializeTextures(JsonObject json) throws JsonParseException {
            HashMap<String, ShaderTextureSource> textures = new HashMap<String, ShaderTextureSource>();
            for (Map.Entry entry : json.entrySet()) {
                String name = (String)entry.getKey();
                DataResult texture = ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
                if (texture.error().isPresent()) {
                    throw new JsonSyntaxException("Failed to deserialize texture: " + name + ". " + ((DataResult.PartialResult)texture.error().get()).message());
                }
                textures.put(name, (ShaderTextureSource)texture.result().orElseThrow());
            }
            ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return Collections.unmodifiableMap(textures);
        }

        public ProgramDefinition deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            Map<String, String> definitionDefaults;
            String[] definitions;
            JsonObject json = element.getAsJsonObject();
            ShaderSource vertex = Deserializer.deserializeSource(json, "vertex", context);
            ShaderSource tesselationControl = Deserializer.deserializeSource(json, "tesselation_control", context);
            ShaderSource tesselationEvaluation = Deserializer.deserializeSource(json, "tesselation_evaluation", context);
            ShaderSource geometry = Deserializer.deserializeSource(json, "geometry", context);
            ShaderSource fragment = Deserializer.deserializeSource(json, "fragment", context);
            ShaderSource compute = Deserializer.deserializeSource(json, "compute", context);
            if (json.has("definitions")) {
                HashMap<String, String> defaults = new HashMap<String, String>();
                definitions = this.deserializeDefinitions(json.getAsJsonArray("definitions"), defaults);
                definitionDefaults = Collections.unmodifiableMap(defaults);
            } else {
                definitions = new String[]{};
                definitionDefaults = Collections.emptyMap();
            }
            Map<String, ShaderTextureSource> textures = json.has("textures") ? this.deserializeTextures(json.getAsJsonObject("textures")) : Collections.emptyMap();
            Int2ObjectArrayMap sources = new Int2ObjectArrayMap();
            if (vertex != null) {
                sources.put(35633, (Object)vertex);
            }
            if (tesselationControl != null) {
                sources.put(36488, (Object)tesselationControl);
            }
            if (tesselationEvaluation != null) {
                sources.put(36487, (Object)tesselationEvaluation);
            }
            if (geometry != null) {
                sources.put(36313, (Object)geometry);
            }
            if (fragment != null) {
                sources.put(35632, (Object)fragment);
            }
            if (compute != null) {
                sources.put(37305, (Object)compute);
            }
            return new ProgramDefinition(vertex, tesselationControl, tesselationEvaluation, geometry, fragment, compute, definitions, definitionDefaults, textures, (Int2ObjectMap<ShaderSource>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)sources));
        }
    }

    public static enum SourceType {
        GLSL,
        GLSL_SPIRV,
        HLSL_SPIRV,
        SPIRV;


        public static SourceType byName(String sourceType) {
            for (SourceType value : SourceType.values()) {
                if (!value.name().equalsIgnoreCase(sourceType)) continue;
                return value;
            }
            throw new JsonSyntaxException("Unknown SourceType: " + sourceType);
        }
    }
}

