package foundry.veil.fabric.mixin.client.stage;

import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.ext.LevelRendererBlockLayerExtension;
import foundry.veil.fabric.FabricRenderTypeStageHandler;
import foundry.veil.fabric.ext.LevelRendererExtension;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.client.renderer.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_761.class)
public class LevelRendererMixin implements LevelRendererExtension {

    @Shadow
    private @Nullable class_638 level;

    @Shadow
    private int ticks;

    @Shadow
    private @Nullable class_4604 capturedFrustum;

    @Shadow
    private class_4604 cullingFrustum;

    @Shadow
    @Final
    private class_4599 renderBuffers;

    @Unique
    private float veil$capturePartialTicks;
    @Unique
    private class_4184 veil$captureCamera;

    @Inject(method = "renderLevel", at = @At("HEAD"))
    public void capture(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci) {
        this.veil$capturePartialTicks = partialTicks;
        this.veil$captureCamera = camera;
    }

    @Inject(method = "renderLevel", at = @At("RETURN"))
    public void clear(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci) {
        this.veil$captureCamera = null;
    }

    @Inject(method = "renderLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V", shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    public void postRenderSky(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci, class_3695 profiler, class_243 cameraPos, double x, double y, double z, Matrix4f matrix4f2, boolean flag, class_4604 frustum) {
        FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, profiler, VeilRenderLevelStageEvent.Stage.AFTER_SKY, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, partialTicks, camera, frustum);
    }

    @Inject(method = "renderLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch(Lnet/minecraft/client/renderer/RenderType;)V", ordinal = 3, shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    public void postRenderEntities(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci, class_3695 profiler, class_243 cameraPos, double x, double y, double z, Matrix4f matrix4f2, boolean flag, class_4604 frustum) {
        FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, profiler, VeilRenderLevelStageEvent.Stage.AFTER_ENTITIES, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, partialTicks, camera, frustum);
    }

    @Inject(method = "renderLevel", at = @At(value = "INVOKE", target = "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;long2ObjectEntrySet()Lit/unimi/dsi/fastutil/objects/ObjectSet;", shift = At.Shift.BEFORE), locals = LocalCapture.CAPTURE_FAILHARD)
    public void postRenderBlockEntities(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci, class_3695 profiler, class_243 cameraPos, double x, double y, double z, Matrix4f matrix4f2, boolean flag, class_4604 frustum) {
        FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, profiler, VeilRenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, partialTicks, camera, frustum);
    }

    @Inject(method = "renderLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/ParticleEngine;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;F)V", shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    public void postRenderParticles(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci, class_3695 profiler, class_243 cameraPos, double x, double y, double z, Matrix4f matrix4f2, boolean flag, class_4604 frustum) {
        FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, profiler, VeilRenderLevelStageEvent.Stage.AFTER_PARTICLES, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, partialTicks, camera, frustum);
    }

    @Inject(method = "renderLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    public void postRenderWeather(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci, class_3695 profiler, class_243 cameraPos, double x, double y, double z, Matrix4f matrix4f2, boolean flag, class_4604 frustum) {
        FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, profiler, VeilRenderLevelStageEvent.Stage.AFTER_WEATHER, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, partialTicks, camera, frustum);
    }

    @Inject(method = "renderLevel", at = @At("TAIL"), locals = LocalCapture.CAPTURE_FAILHARD)
    public void postRenderLevel(class_4587 poseStack, float partialTicks, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projection, CallbackInfo ci, class_3695 profiler, class_243 cameraPos, double x, double y, double z, Matrix4f matrix4f2, boolean flag, class_4604 frustum) {
        FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, profiler, VeilRenderLevelStageEvent.Stage.AFTER_LEVEL, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, partialTicks, camera, frustum);
    }

    @Override
    public void veil$renderStage(class_1921 layer, class_4587 poseStack, Matrix4f projection) {
        VeilRenderLevelStageEvent.Stage stage;
        if (layer == class_1921.method_23577()) {
            stage = VeilRenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS;
        } else if (layer == class_1921.method_23579()) {
            stage = VeilRenderLevelStageEvent.Stage.AFTER_CUTOUT_MIPPED_BLOCKS;
        } else if (layer == class_1921.method_23581()) {
            stage = VeilRenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS;
        } else if (layer == class_1921.method_23583()) {
            stage = VeilRenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS;
        } else if (layer == class_1921.method_29997()) {
            stage = VeilRenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS;
        } else {
            stage = null;
        }

        if (stage != null) {
            FabricRenderTypeStageHandler.renderStage((LevelRendererBlockLayerExtension) this, this.level.method_16107(), stage, (class_761) (Object) this, this.renderBuffers.method_23000(), poseStack, projection, this.ticks, this.veil$capturePartialTicks, this.veil$captureCamera, this.capturedFrustum != null ? this.capturedFrustum : this.cullingFrustum);
        }
    }
}
