package foundry.veil.api.quasar.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.util.CodecUtil;
import java.util.List;
import net.minecraft.class_6880;

public record EmitterSettings(List<class_6880<EmitterShapeSettings>> emitterShapeSettingsHolders,
                              class_6880<ParticleSettings> particleSettingsHolder,
                              boolean forceSpawn) {

    public static final Codec<EmitterSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            CodecUtil.singleOrList(EmitterShapeSettings.CODEC).fieldOf("shape").forGetter(EmitterSettings::emitterShapeSettingsHolders),
            ParticleSettings.CODEC.fieldOf("particle_settings").forGetter(EmitterSettings::particleSettingsHolder),
            Codec.BOOL.optionalFieldOf("force_spawn", false).forGetter(EmitterSettings::forceSpawn)
    ).apply(instance, EmitterSettings::new));

    public List<EmitterShapeSettings> emitterShapeSettings() {
        return this.emitterShapeSettingsHolders.stream().map(class_6880::comp_349).toList();
    }

    public ParticleSettings particleSettings() {
        return this.particleSettingsHolder.comp_349();
    }
}
