package foundry.veil.api.client.graveyard.render;

import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import foundry.veil.api.client.graveyard.skeleton.SkeletonFactory;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class InterpolatedEntityRenderLayer<T extends class_1309 & InterpolatedSkeletonParent, M extends InterpolatedSkeleton> {
    public InterpolatedEntityRenderer<T, M> renderer;

    public InterpolatedEntityRenderLayer(InterpolatedEntityRenderer<T, M> pRenderer) {
        this.renderer = pRenderer;
    }

    public abstract void render(class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight, T pLivingEntity, M pSkeleton, float pPartialTicks);

    protected SkeletonFactory<M> getModelFactory() {
        return this.renderer.modelFactory;
    }
}
