/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.molang.VeilMolang;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.resource.type.FramebufferResource;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.api.exception.MolangSyntaxException;
import imgui.ImDrawList;
import imgui.ImFont;
import imgui.ImFontGlyph;
import imgui.ImGui;
import imgui.ImGuiStyle;
import imgui.ImVec4;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class FramebufferFileEditor
implements ResourceFileEditor<FramebufferResource> {
    private static final StringBuilder BUILDER = new StringBuilder();
    private final ImBoolean open;
    private FramebufferResource resource;
    private FramebufferDefinitionBuilder builder;
    private final ImString widthInput = new ImString();
    private final ImString heightInput = new ImString();
    private BitSet enabledBuffers;
    private int attachmentIndex;
    private FramebufferAttachmentDefinition.Type type;
    private FramebufferAttachmentDefinition.Format format;
    private FramebufferAttachmentDefinition.DataType dataType;
    private boolean linear;
    private int levels;
    private String name;

    public FramebufferFileEditor() {
        this.open = new ImBoolean(false);
    }

    @Override
    public void render() {
        if (this.resource == null || !this.open.get()) {
            return;
        }
        if (ImGui.begin((String)("Framebuffer Editor: " + this.resource.resourceInfo().fileName() + "###framebuffer_editor"))) {
            class_2960 id;
            FramebufferManager framebufferManager;
            AdvancedFbo fbo;
            class_1041 window = class_310.method_1551().method_22683();
            MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)window.method_4489()).setQuery("screen_height", (float)window.method_4506()).create();
            float definitionWidth = 1.0f;
            float definitionHeight = 1.0f;
            try {
                definitionWidth = runtime.resolve(this.builder.getWidth());
                definitionHeight = runtime.resolve(this.builder.getHeight());
            }
            catch (MolangRuntimeException e) {
                e.printStackTrace();
            }
            float aspectRatio = definitionHeight / definitionWidth;
            float lineHeight = ImGui.getTextLineHeightWithSpacing();
            float boxWidth = ImGui.getContentRegionAvailX() / 2.0f;
            float boxHeight = boxWidth * aspectRatio;
            ImGui.pushStyleVar((int)2, (float)0.0f, (float)0.0f);
            if (ImGui.beginChild((String)"##size", (float)boxWidth, (float)boxHeight, (boolean)true) && (fbo = (framebufferManager = VeilRenderSystem.renderer().getFramebufferManager()).getFramebuffer(id = FramebufferManager.FRAMEBUFFER_LISTER.method_45115(this.resource.resourceInfo().location()))) != null) {
                int textureId = 0;
                if (this.attachmentIndex == 0) {
                    if (fbo.isDepthTextureAttachment()) {
                        textureId = fbo.getDepthTextureAttachment().method_4624();
                    }
                } else if (fbo.isColorTextureAttachment(this.attachmentIndex - 1)) {
                    textureId = fbo.getColorTextureAttachment(this.attachmentIndex - 1).method_4624();
                }
                if (textureId > 0) {
                    ImGui.image((int)textureId, (float)boxWidth, (float)boxHeight, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
                }
            }
            ImGui.endChild();
            ImGui.popStyleVar();
            VeilImGuiUtil.textCentered(Integer.toString((int)definitionWidth), boxWidth);
            if (ImGui.beginChild((String)"##panel", (float)(ImGui.getContentRegionAvailX() / 2.0f), (float)ImGui.getContentRegionAvailY())) {
                ImGui.text((String)"Framebuffer Settings:");
                this.renderFramebufferSettings();
                ImGui.newLine();
                ImGui.text((String)"Attachment Settings:");
                this.renderAttachmentSettings();
            }
            ImGui.endChild();
            String heightString = Integer.toString((int)definitionHeight);
            ImFont font = ImGui.getFont();
            float width = font.calcTextSizeAX((float)ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, heightString);
            ImGui.setCursorPos((float)(ImGui.getCursorStartPosX() + boxWidth), (float)(ImGui.getCursorStartPosY() + boxHeight / 2.0f + width / 2.0f));
            FramebufferFileEditor.drawVerticalText(heightString);
            ImGui.setCursorPos((float)(ImGui.getCursorStartPosX() + ImGui.getContentRegionMaxX() / 2.0f + lineHeight), (float)ImGui.getCursorStartPosY());
            ImGui.beginGroup();
            if (ImGui.beginListBox((String)"##buffers", (float)ImGui.getContentRegionAvailX(), (float)(ImGui.getContentRegionAvailY() - ImGui.getFrameHeight() - ImGui.getStyle().getFramePaddingY() * 2.0f))) {
                float itemWidth = ImGui.getContentRegionAvailX();
                boolean useDepth = this.enabledBuffers.get(0);
                if (useDepth) {
                    if (ImGui.invisibleButton((String)"##depth", (float)itemWidth, (float)(lineHeight * 4.0f))) {
                        this.setAttachment(0);
                    }
                    if (this.builder.getDepthBuffer() == null) {
                        this.builder.setDepthBuffer(new FramebufferAttachmentDefinition(FramebufferAttachmentDefinition.Type.TEXTURE, FramebufferAttachmentDefinition.Format.DEPTH_COMPONENT, FramebufferAttachmentDefinition.DataType.FLOAT, true, false, 0, null));
                    }
                    FramebufferFileEditor.drawBuffer("Depth Buffer", this.builder.getDepthBuffer(), itemWidth, this.attachmentIndex == 0);
                }
                for (int i = 0; i < this.enabledBuffers.size() - 1; ++i) {
                    FramebufferAttachmentDefinition[] colorBuffers;
                    boolean enabled = this.enabledBuffers.get(i + 1);
                    if (!enabled) continue;
                    if (ImGui.invisibleButton((String)("##color" + i), (float)itemWidth, (float)(lineHeight * 4.0f))) {
                        this.setAttachment(i + 1);
                    }
                    if ((colorBuffers = this.builder.getColorBuffers())[i] == null) {
                        this.builder.setColorBuffer(i, new FramebufferAttachmentDefinition(FramebufferAttachmentDefinition.Type.TEXTURE, FramebufferAttachmentDefinition.Format.RGBA8, FramebufferAttachmentDefinition.DataType.UNSIGNED_BYTE, false, false, 0, null));
                    }
                    FramebufferFileEditor.drawBuffer("Color Buffer " + i, colorBuffers[i], itemWidth, this.attachmentIndex == i + 1);
                }
                ImGui.endListBox();
            }
            if (ImGui.checkbox((String)"Use Depth", (boolean)this.enabledBuffers.get(0))) {
                this.enabledBuffers.flip(0);
                if (this.attachmentIndex == 0 && !this.enabledBuffers.get(0)) {
                    this.setAttachment(1);
                }
            }
            ImGui.endGroup();
        }
        ImGui.end();
    }

    private static void drawBuffer(String name, FramebufferAttachmentDefinition attachment, float width, boolean selected) {
        ImGuiStyle style = ImGui.getStyle();
        float lineHeight = ImGui.getTextLineHeightWithSpacing();
        boolean hovered = ImGui.isItemHovered();
        boolean active = selected || ImGui.isItemActive();
        ImGui.sameLine();
        ImGui.setCursorPosX((float)ImGui.getCursorStartPosX());
        ImVec4 col = new ImVec4();
        style.getColor(active ? 23 : (hovered ? 22 : 21), col);
        int colorU32 = ImGui.getColorU32((float)col.x, (float)col.y, (float)col.z, (float)col.w);
        float x = ImGui.getCursorScreenPosX();
        float y = ImGui.getCursorScreenPosY();
        ImGui.getWindowDrawList().addRectFilled(x, y, x + width, y + lineHeight * 4.0f, colorU32);
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + style.getFramePaddingX()));
        ImGui.beginGroup();
        boolean texture = attachment.type() == FramebufferAttachmentDefinition.Type.TEXTURE;
        FramebufferFileEditor.text(builder -> {
            builder.append(name);
            if (attachment.name() != null) {
                builder.append(" (").append(attachment.name()).append(")");
            }
        });
        FramebufferFileEditor.text(builder -> {
            builder.append(attachment.type().getDisplayName());
            if (texture) {
                builder.append(attachment.linear() ? " Linear" : " Nearest");
            }
        });
        FramebufferFileEditor.text(builder -> builder.append(attachment.format().name()).append(" ").append(attachment.dataType().name()));
        FramebufferFileEditor.text(builder -> builder.append(attachment.levels()).append(texture ? " Mipmaps" : " Samples"));
        ImGui.endGroup();
    }

    private static void text(Consumer<StringBuilder> text) {
        text.accept(BUILDER);
        ImGui.text((String)BUILDER.toString());
        BUILDER.setLength(0);
    }

    private static void drawVerticalText(String next) {
        ImFont font = ImGui.getFont();
        float pad = ImGui.getStyle().getFramePaddingX();
        float posX = ImGui.getCursorScreenPosX() + pad;
        float posY = ImGui.getCursorScreenPosY() + pad;
        ImDrawList drawList = ImGui.getWindowDrawList();
        for (int i = 0; i < next.length(); ++i) {
            int codePoint = next.codePointAt(i);
            ImFontGlyph glyph = font.findGlyph(codePoint);
            drawList.primReserve(6, 4);
            drawList.primQuadUV((float)((int)(posX + glyph.getY1())), (float)((int)((posY -= font.getCharAdvance(codePoint)) + glyph.getX0())), (float)((int)(posX + glyph.getY1())), (float)((int)(posY + glyph.getX1())), (float)((int)(posX + glyph.getY0())), (float)((int)(posY + glyph.getX1())), (float)((int)(posX + glyph.getY0())), (float)((int)(posY + glyph.getX0())), glyph.getU1(), glyph.getV1(), glyph.getU0(), glyph.getV1(), glyph.getU0(), glyph.getV0(), glyph.getU1(), glyph.getV0(), -1);
        }
    }

    private void renderFramebufferSettings() {
        if (ImGui.inputText((String)"Width", (ImString)this.widthInput, (int)32)) {
            try {
                this.builder.setWidth(VeilMolang.get().compile(this.widthInput.get()));
            }
            catch (MolangSyntaxException e) {
                e.printStackTrace();
            }
            this.updateSize();
        }
        if (ImGui.inputText((String)"Height", (ImString)this.heightInput, (int)32)) {
            try {
                this.builder.setHeight(VeilMolang.get().compile(this.heightInput.get()));
            }
            catch (MolangSyntaxException e) {
                e.printStackTrace();
            }
            this.updateSize();
        }
    }

    private void renderAttachmentSettings() {
        if (ImGui.beginCombo((String)"Type", (String)this.type.getDisplayName())) {
            for (FramebufferAttachmentDefinition.Type type : FramebufferAttachmentDefinition.Type.values()) {
                if (!ImGui.selectable((String)type.getDisplayName())) continue;
                this.type = type;
                this.saveAttachment();
            }
            ImGui.endCombo();
        }
    }

    private void updateSize() {
        String width = this.builder.getWidth().toString();
        if (width.startsWith("return")) {
            this.widthInput.set(width.substring(7));
        } else {
            this.widthInput.set(width);
        }
        String height = this.builder.getHeight().toString();
        if (height.startsWith("return")) {
            this.heightInput.set(height.substring(7));
        } else {
            this.heightInput.set(height);
        }
    }

    private void saveAttachment() {
        if (this.attachmentIndex == 0) {
            this.builder.setDepthBuffer(new FramebufferAttachmentDefinition(this.type, this.format, this.dataType, true, this.linear, this.levels, this.name));
        } else {
            this.builder.setColorBuffer(this.attachmentIndex - 1, new FramebufferAttachmentDefinition(this.type, this.format, this.dataType, false, this.linear, this.levels, this.name));
        }
    }

    private void setAttachment(int attachmentIndex) {
        FramebufferAttachmentDefinition buffer;
        this.attachmentIndex = attachmentIndex;
        if (this.attachmentIndex == 0) {
            buffer = this.builder.getDepthBuffer();
        } else {
            FramebufferAttachmentDefinition[] colorBuffers = this.builder.getColorBuffers();
            if (attachmentIndex < 1 || attachmentIndex >= colorBuffers.length + 1) {
                return;
            }
            buffer = colorBuffers[attachmentIndex - 1];
        }
        if (buffer != null) {
            this.type = buffer.type();
            this.format = buffer.format();
            this.dataType = buffer.dataType();
            this.linear = buffer.linear();
            this.levels = buffer.levels();
            this.name = buffer.name();
        }
    }

    @Override
    public void open(VeilEditorEnvironment environment, FramebufferResource resource) {
        this.open.set(true);
        this.resource = resource;
        class_3300 resourceManager = environment.getResourceManager().clientResources();
        class_2960 location = resource.resourceInfo().location();
        try (BufferedReader reader = resourceManager.getResourceOrThrow(location).method_43039();){
            DataResult result = FramebufferDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader));
            if (result.error().isPresent()) {
                throw new JsonParseException(((DataResult.PartialResult)result.error().get()).message());
            }
            this.builder = new FramebufferDefinitionBuilder((FramebufferDefinition)result.result().orElseThrow());
        }
        catch (IOException e) {
            Veil.LOGGER.error("Failed to open resource: {}", (Object)location, (Object)e);
            this.builder = new FramebufferDefinitionBuilder();
        }
        if (this.enabledBuffers == null) {
            this.enabledBuffers = new BitSet(VeilRenderSystem.maxColorAttachments() + 1);
        }
        FramebufferAttachmentDefinition[] colorBuffers = this.builder.getColorBuffers();
        this.enabledBuffers.set(0, this.builder.getDepthBuffer() != null);
        for (int i = 0; i < colorBuffers.length; ++i) {
            this.enabledBuffers.set(i + 1, colorBuffers[i] != null);
        }
        this.updateSize();
        this.setAttachment(1);
    }

    private static class FramebufferDefinitionBuilder {
        private MolangExpression width;
        private MolangExpression height;
        private final FramebufferAttachmentDefinition[] colorBuffers;
        @Nullable
        private FramebufferAttachmentDefinition depthBuffer;
        private boolean autoClear;

        public FramebufferDefinitionBuilder() {
            this.width = FramebufferDefinition.DEFAULT_WIDTH;
            this.height = FramebufferDefinition.DEFAULT_HEIGHT;
            this.colorBuffers = new FramebufferAttachmentDefinition[VeilRenderSystem.maxColorAttachments()];
            this.depthBuffer = null;
            this.autoClear = true;
        }

        public FramebufferDefinitionBuilder(FramebufferDefinition definition) {
            this.width = definition.width();
            this.height = definition.height();
            this.colorBuffers = Arrays.copyOf(definition.colorBuffers(), VeilRenderSystem.maxColorAttachments());
            this.depthBuffer = definition.depthBuffer();
            this.autoClear = definition.autoClear();
        }

        public void setWidth(MolangExpression width) {
            this.width = width;
        }

        public void setHeight(MolangExpression height) {
            this.height = height;
        }

        public void setColorBuffer(int index, FramebufferAttachmentDefinition colorBuffer) {
            this.colorBuffers[index] = colorBuffer;
        }

        public void setDepthBuffer(@Nullable FramebufferAttachmentDefinition depthBuffer) {
            this.depthBuffer = depthBuffer;
        }

        public void setAutoClear(boolean autoClear) {
            this.autoClear = autoClear;
        }

        public MolangExpression getWidth() {
            return this.width;
        }

        public MolangExpression getHeight() {
            return this.height;
        }

        public FramebufferAttachmentDefinition[] getColorBuffers() {
            return this.colorBuffers;
        }

        @Nullable
        public FramebufferAttachmentDefinition getDepthBuffer() {
            return this.depthBuffer;
        }

        public boolean isAutoClear() {
            return this.autoClear;
        }
    }
}

