package foundry.veil.impl.client.render;

import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;
import org.joml.Vector3f;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;

public class LevelPerspectiveCamera extends class_4184 {

    private static final Vector3f EULER_ANGLES = new Vector3f();

    public void setup(Vector3dc position, @Nullable class_1297 cameraEntity, class_638 level, Quaternionfc orientation) {
        super.method_19321(level, cameraEntity != null ? cameraEntity : Objects.requireNonNull(class_310.method_1551().field_1724), true, false, 1.0F);
        this.method_19327(position.x(), position.y(), position.z());

        orientation.getEulerAnglesYXZ(EULER_ANGLES);
        super.method_19325((float) (-EULER_ANGLES.y * 180 / Math.PI), (float) (EULER_ANGLES.x * 180 / Math.PI));
        this.method_23767().set(orientation);
        this.method_19335().set(0.0F, 0.0F, 1.0F).rotate(orientation);
        this.method_19336().set(0.0F, 1.0F, 0.0F).rotate(orientation);
        this.method_35689().set(1.0F, 0.0F, 0.0F).rotate(orientation);
    }
}
