/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.resource.loader;

import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceLoader;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.TextResource;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;

public class TextResourceLoader
implements VeilResourceLoader {
    @Override
    public boolean canLoad(PackType packType, ResourceLocation location, @Nullable Path filePath, @Nullable Path modResourcePath) {
        for (TextResource.Type type : TextResource.Type.values()) {
            if (!location.getPath().endsWith(type.getExtension())) continue;
            return true;
        }
        return false;
    }

    @Override
    public VeilResource<?> load(VeilResourceManager resourceManager, ResourceProvider provider, PackType packType, ResourceLocation location, @Nullable Path filePath, @Nullable Path modResourcePath) throws IOException {
        for (TextResource.Type type : TextResource.Type.values()) {
            if (!location.getPath().endsWith(type.getExtension())) continue;
            return new TextResource(new VeilResourceInfo(packType, location, filePath, modResourcePath, false), type);
        }
        throw new IOException("Unknown text resource: " + location);
    }
}

