/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.particle.QuasarParticle;
import foundry.veil.api.quasar.particle.RenderData;
import foundry.veil.api.quasar.particle.SpriteData;
import foundry.veil.api.quasar.registry.RenderStyleRegistry;
import foundry.veil.api.util.CodecUtil;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface RenderStyle {
    public static final Codec<RenderStyle> CODEC = CodecUtil.registryOrLegacyCodec(RenderStyleRegistry.REGISTRY);

    public void render(PoseStack var1, QuasarParticle var2, RenderData var3, Vector3fc var4, VertexConsumer var5, double var6, float var8);

    public static final class Billboard
    implements RenderStyle {
        private static final Vector3fc[] PLANE_POSITIONS = new Vector3fc[]{new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)};

        @Override
        public void render(PoseStack poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, VertexConsumer builder, double ageModifier, float partialTicks) {
            Matrix4f matrix4f = poseStack.last().pose();
            Vector3fc rotation = renderData.getRenderRotation();
            Quaternionf faceCameraRotation = Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation();
            SpriteData spriteData = renderData.getSpriteData();
            int red = (int)(renderData.getRed() * 255.0f) & 0xFF;
            int green = (int)(renderData.getGreen() * 255.0f) & 0xFF;
            int blue = (int)(renderData.getBlue() * 255.0f) & 0xFF;
            int alpha = (int)(renderData.getAlpha() * 255.0f) & 0xFF;
            Vector3f vec = new Vector3f();
            for (int j = 0; j < 4; ++j) {
                float v;
                float u;
                vec.set(PLANE_POSITIONS[j]);
                if (particle.getData().velocityStretchFactor() > 0.0f) {
                    vec.set(vec.x * (1.0f + particle.getData().velocityStretchFactor()), vec.y, vec.z);
                }
                if (particle.getData().faceVelocity()) {
                    vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z());
                }
                faceCameraRotation.transform(vec).mul((float)((double)renderData.getRenderRadius() * ageModifier)).add(renderOffset);
                if (j == 0) {
                    u = 0.0f;
                    v = 0.0f;
                } else if (j == 1) {
                    u = 1.0f;
                    v = 0.0f;
                } else if (j == 2) {
                    u = 1.0f;
                    v = 1.0f;
                } else {
                    u = 0.0f;
                    v = 1.0f;
                }
                if (spriteData != null) {
                    u = spriteData.u(renderData.getRenderAge(), renderData.getAgePercent(), u);
                    v = spriteData.v(renderData.getRenderAge(), renderData.getAgePercent(), v);
                }
                builder.vertex(matrix4f, vec.x, vec.y, vec.z);
                builder.uv(u, v);
                builder.color(red, green, blue, alpha);
                builder.uv2(renderData.getLightColor());
                builder.endVertex();
            }
        }
    }

    public static final class Cube
    implements RenderStyle {
        private static final Vector3fc[] CUBE_POSITIONS = new Vector3fc[]{new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f)};

        @Override
        public void render(PoseStack poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, VertexConsumer builder, double ageModifier, float partialTicks) {
            Matrix4f matrix4f = poseStack.last().pose();
            Vector3fc rotation = renderData.getRenderRotation();
            Vector3f vec = new Vector3f();
            SpriteData spriteData = renderData.getSpriteData();
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    vec.set(CUBE_POSITIONS[i * 4 + j]);
                    QuasarParticleData data = particle.getData();
                    if (vec.z < 0.0f && data.velocityStretchFactor() != 0.0f) {
                        vec.z *= 1.0f + data.velocityStretchFactor();
                    }
                    vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z()).mul((float)((double)renderData.getRenderRadius() * ageModifier)).add(renderOffset);
                    float u = (int)((float)j / 2.0f);
                    float v = j % 2;
                    if (spriteData != null) {
                        u = spriteData.u(renderData.getRenderAge(), renderData.getAgePercent(), u);
                        v = spriteData.v(renderData.getRenderAge(), renderData.getAgePercent(), v);
                    }
                    builder.vertex(matrix4f, vec.x, vec.y, vec.z);
                    builder.uv(u, v);
                    builder.color(renderData.getRed(), renderData.getGreen(), renderData.getBlue(), renderData.getAlpha());
                    builder.uv2(renderData.getLightColor());
                    builder.endVertex();
                }
            }
        }
    }
}

