/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype.layer;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.client.render.rendertype.layer.CompositeRenderTypeData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;

public class DynamicRenderTypeManager
extends class_4080<Map<class_2960, byte[]>> {
    private static final class_7654 CONVERTER = class_7654.method_45114((String)"pinwheel/rendertypes");

    @NotNull
    protected Map<class_2960, byte[]> prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        HashMap<class_2960, byte[]> data = new HashMap<class_2960, byte[]>();
        Map resources = CONVERTER.method_45113(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            class_2960 id = CONVERTER.method_45115(location);
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    data.put(id, stream.readAllBytes());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't read data file {} from {}", new Object[]{id, location, e});
            }
        }
        return data;
    }

    protected void apply(Map<class_2960, byte[]> fileData, class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, class_1921> renderTypes = new HashMap<class_2960, class_1921>();
        int injections = 0;
        for (Map.Entry<class_2960, byte[]> entry : fileData.entrySet()) {
            class_2960 id = entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(entry.getValue()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                DataResult result = CompositeRenderTypeData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(((DataResult.PartialResult)result.error().get()).message());
                }
                CompositeRenderTypeData data = (CompositeRenderTypeData)result.result().orElseThrow();
                if (data.inject() != null) {
                    ++injections;
                    continue;
                }
                if (renderTypes.put(id, data.createRenderType(id.toString())) == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + id);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, CONVERTER.method_45112(id), e});
            }
        }
        Veil.LOGGER.info("Loaded {} render types", (Object)(renderTypes.size() + injections));
    }
}

