/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.stage;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.render.post.PostPipeline;

public record DepthFunctionPostStage(DepthFunc func) implements PostPipeline
{
    public static final Codec<DepthFunctionPostStage> CODEC = DepthFunc.CODEC.fieldOf("function").xmap(DepthFunctionPostStage::new, DepthFunctionPostStage::func).codec();

    @Override
    public void apply(PostPipeline.Context context) {
        RenderSystem.depthFunc((int)this.func.getId());
    }

    @Override
    public PostPipelineStageRegistry.PipelineType<? extends PostPipeline> getType() {
        return PostPipelineStageRegistry.DEPTH_FUNC.get();
    }

    public static enum DepthFunc {
        NEVER(512),
        LESS(513),
        EQUAL(514),
        LEQUAL(515),
        GREATER(516),
        NOTEQUAL(517),
        GEQUAL(518),
        ALWAYS(519);

        public static final Codec<DepthFunc> CODEC;
        private final int id;

        private DepthFunc(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        static {
            CODEC = Codec.STRING.flatXmap(name -> {
                for (DepthFunc type : DepthFunc.values()) {
                    if (!type.name().equalsIgnoreCase((String)name)) continue;
                    return DataResult.success((Object)((Object)type));
                }
                return DataResult.error(() -> "Unknown depth function: " + name);
            }, type -> DataResult.success((Object)type.name()));
        }
    }
}

