package foundry.veil.api.client.render.shader;

import foundry.veil.Veil;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

/**
 * Default shader names.
 */
public final class VeilShaders {

    private VeilShaders() {
    }

    public static final class_2960 PARTICLE = quasar("particle");
    public static final class_2960 PARTICLE_ADD = quasar("particle_add");

    public static final class_2960 LIGHT_AMBIENT = light("ambient");
    public static final class_2960 LIGHT_DIRECTIONAL = light("directional");
    public static final class_2960 LIGHT_POINT = light("point");
    public static final class_2960 LIGHT_AREA = light("area");
    public static final class_2960 LIGHT_VANILLA_LIGHTMAP = light("vanilla_lightmap");
    public static final class_2960 LIGHT_SKY = light("sky");
    public static final class_2960 LIGHT_INDIRECT_SPHERE = light("indirect_sphere");

    public static final class_2960 SKINNED_MESH = necromancer("skinned_mesh");

    public static final class_2960 DEBUG_CUBEMAP = debug("cubemap");

    private static class_2960 quasar(String name) {
        return Veil.veilPath("quasar/" + name);
    }

    private static class_2960 light(String name) {
        return Veil.veilPath("light/" + name);
    }

    private static class_2960 necromancer(String name) {
        return Veil.veilPath("necromancer/" + name);
    }

    private static class_2960 debug(String name) {
        return Veil.veilPath("debug/" + name);
    }
}
