/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.quasar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.util.CodecUtil;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class ColorGradient {
    private static final Codec<Vector4fc> SINGLE_COLOR_CODEC = CodecUtil.VECTOR4F_CODEC.fieldOf("color").codec();
    private static final Codec<ColorGradient> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RGBPoint.CODEC.listOf().fieldOf("rgb_points").forGetter(ColorGradient::getPoints), (App)AlphaPoint.CODEC.listOf().fieldOf("alpha_points").forGetter(ColorGradient::getAlphaPoints)).apply((Applicative)instance, ColorGradient::new));
    public static final Codec<ColorGradient> CODEC = Codec.either(SINGLE_COLOR_CODEC, FULL_CODEC).xmap(either -> (ColorGradient)either.map(left -> new ColorGradient(left.x(), left.y(), left.z(), left.w()), right -> right), gradient -> {
        if (gradient.isConstant()) {
            Vec3 point = gradient.points[0].color;
            return Either.left((Object)new Vector4f((float)point.x, (float)point.y, (float)point.z, gradient.alphaPoints[0].alpha));
        }
        return Either.right((Object)gradient);
    });
    private final RGBPoint[] points;
    private final AlphaPoint[] alphaPoints;

    public ColorGradient(float red, float green, float blue, float alpha) {
        this.points = new RGBPoint[]{new RGBPoint(0.0f, new Vec3((double)red, (double)green, (double)blue))};
        this.alphaPoints = new AlphaPoint[]{new AlphaPoint(0.0f, alpha)};
    }

    public ColorGradient(RGBPoint[] points, AlphaPoint[] alphaPoints) {
        this.points = points;
        this.alphaPoints = alphaPoints;
    }

    public ColorGradient(RGBPoint[] points) {
        this(points, new AlphaPoint[]{new AlphaPoint(0.0f, 0.0f), new AlphaPoint(1.0f, 1.0f)});
    }

    public ColorGradient(List<RGBPoint> points, List<AlphaPoint> alphaPoints) {
        this(points.toArray(new RGBPoint[0]), alphaPoints.toArray(new AlphaPoint[0]));
    }

    public ColorGradient(Vec3 startColor, Vec3 endColor, float startAlpha, float endAlpha) {
        this(new RGBPoint[]{new RGBPoint(0.0f, startColor), new RGBPoint(1.0f, endColor)}, new AlphaPoint[]{new AlphaPoint(0.0f, startAlpha), new AlphaPoint(1.0f, endAlpha)});
    }

    public ColorGradient(Vec3 startColor, Vec3 endColor) {
        this(new RGBPoint[]{new RGBPoint(0.0f, startColor), new RGBPoint(1.0f, endColor)});
    }

    public boolean isConstant() {
        return this.points.length == 1 && this.alphaPoints.length == 1;
    }

    public Vector4f getColor(float percentage) {
        return this.getColor(percentage, new Vector4f());
    }

    public Vector4f getColor(float percentage, Vector4f store) {
        Vec3 rgb = this.getRGB(percentage);
        float alpha = this.getAlpha(percentage);
        return store.set(rgb.x, rgb.y, rgb.z, (double)alpha);
    }

    private float getAlpha(float percentage) {
        if (this.alphaPoints.length == 0) {
            return 1.0f;
        }
        if (this.alphaPoints.length == 1) {
            return this.alphaPoints[0].alpha;
        }
        for (int i = 0; i < this.alphaPoints.length - 1; ++i) {
            if (!(percentage >= this.alphaPoints[i].percent) || !(percentage <= this.alphaPoints[i + 1].percent)) continue;
            return Mth.lerp((float)((percentage - this.alphaPoints[i].percent) / (this.alphaPoints[i + 1].percent - this.alphaPoints[i].percent)), (float)this.alphaPoints[i].alpha, (float)this.alphaPoints[i + 1].alpha);
        }
        return this.alphaPoints[this.alphaPoints.length - 1].alpha;
    }

    private Vec3 getRGB(float percentage) {
        if (this.points.length == 1) {
            return this.points[0].color;
        }
        for (int i = 0; i < this.points.length - 1; ++i) {
            if (!(percentage >= this.points[i].percent) || !(percentage <= this.points[i + 1].percent)) continue;
            return this.points[i].color.lerp(this.points[i + 1].color, (double)((percentage - this.points[i].percent) / (this.points[i + 1].percent - this.points[i].percent)));
        }
        return this.points[this.points.length - 1].color;
    }

    public List<RGBPoint> getPoints() {
        return List.of(this.points);
    }

    public List<AlphaPoint> getAlphaPoints() {
        return List.of(this.alphaPoints);
    }

    public record RGBPoint(float percent, Vec3 color) {
        public static final Codec<RGBPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("percent").forGetter(RGBPoint::percent), (App)Vec3.CODEC.fieldOf("color").forGetter(RGBPoint::color)).apply((Applicative)instance, RGBPoint::new));
    }

    public record AlphaPoint(float percent, float alpha) {
        public static final Codec<AlphaPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("percent").forGetter(AlphaPoint::percent), (App)Codec.FLOAT.fieldOf("alpha").forGetter(AlphaPoint::alpha)).apply((Applicative)instance, AlphaPoint::new));
    }
}

