/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.pipeline.PatchState;
import foundry.veil.impl.client.render.pipeline.ShaderProgramState;
import foundry.veil.impl.client.render.wrapper.VanillaAdvancedFboWrapper;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;

public interface VeilRenderBridge {
    public static CullFrustum create(Frustum frustum) {
        return (CullFrustum)frustum;
    }

    public static VeilRenderTypeBuilder create(RenderType.CompositeState.CompositeStateBuilder builder) {
        return (VeilRenderTypeBuilder)builder;
    }

    public static MatrixStack create(PoseStack poseStack) {
        return (MatrixStack)poseStack;
    }

    public static AdvancedFbo wrap(RenderTarget renderTarget) {
        return VeilRenderBridge.wrap(() -> renderTarget);
    }

    public static AdvancedFbo wrap(Supplier<RenderTarget> renderTargetSupplier) {
        return new VanillaAdvancedFboWrapper(renderTargetSupplier);
    }

    public static RenderStateShard.ShaderStateShard shaderState(ResourceLocation shader) {
        return new ShaderProgramState(() -> VeilRenderSystem.renderer().getShaderManager().getShader(shader));
    }

    public static RenderStateShard.ShaderStateShard shaderState(ShaderProgram shader) {
        return new ShaderProgramState(() -> shader);
    }

    public static RenderStateShard.ShaderStateShard shaderState(Supplier<ShaderProgram> shader) {
        return new ShaderProgramState(shader);
    }

    public static RenderStateShard.OutputStateShard outputState(ResourceLocation framebuffer) {
        return VeilRenderBridge.outputState(() -> VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(framebuffer));
    }

    public static RenderStateShard.OutputStateShard outputState(AdvancedFbo framebuffer) {
        return VeilRenderBridge.outputState(() -> framebuffer);
    }

    public static RenderStateShard.OutputStateShard outputState(Supplier<AdvancedFbo> framebuffer) {
        return new RenderStateShard.OutputStateShard("advanced_fbo", () -> {
            AdvancedFbo fbo = (AdvancedFbo)framebuffer.get();
            if (fbo != null) {
                fbo.bindDraw(true);
            }
        }, AdvancedFbo::unbindDraw);
    }

    public static PatchState patchState(int patchVertices) {
        return new PatchState(patchVertices);
    }
}

