/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import foundry.veil.api.client.render.CachedBufferSource;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.fabric.event.FabricFreeNativeResourcesEvent;
import foundry.veil.fabric.event.FabricVeilRenderLevelStageEvent;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FabricQuasarParticleHandler {
    private static CachedBufferSource cachedBufferSource;

    private static void free() {
        if (cachedBufferSource != null) {
            cachedBufferSource.free();
            cachedBufferSource = null;
        }
    }

    public static void setLevel(class_638 level) {
        VeilRenderSystem.renderer().getParticleManager().setLevel(level);
        FabricQuasarParticleHandler.free();
    }

    public static void init() {
        FabricFreeNativeResourcesEvent.EVENT.register(FabricQuasarParticleHandler::free);
        FabricVeilRenderLevelStageEvent.EVENT.register((stage, levelRenderer, bufferSource, poseStack, projectionMatrix, renderTick, partialTicks, camera, frustum) -> {
            if (stage == VeilRenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                if (cachedBufferSource == null) {
                    cachedBufferSource = new CachedBufferSource();
                }
                VeilRenderSystem.renderer().getParticleManager().render(poseStack, cachedBufferSource, camera, VeilRenderer.getCullingFrustum(), partialTicks);
                cachedBufferSource.endBatch();
            }
        });
    }
}

