package foundry.veil.impl.client;


import foundry.veil.api.client.pose.ExtendedPose;
import foundry.veil.api.client.pose.PoseData;
import foundry.veil.api.client.registry.PoseRegistry;
import org.jetbrains.annotations.ApiStatus;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_759;

@ApiStatus.Internal
public class PoseHelper {
    public static boolean poseItemUsing(PoseData data, class_759 pRenderer) {
        AtomicBoolean flag = new AtomicBoolean(false);
        PoseRegistry.poses.forEach((item, pose) -> {
            if (item == null || pose == null) return;
            pose.data = data;
            if (item.test(data.stack.method_7909())) {
                pose.poseItemUsing(pRenderer);
                flag.set(pose.overrideItemTransform());
            }
        });
        return flag.get();
    }

    public static boolean poseItem(PoseData data, class_759 pRenderer) {
        AtomicBoolean flag = new AtomicBoolean(false);
        PoseRegistry.poses.forEach((item, pose) -> {
            if (item == null || pose == null) return;
            pose.data = data;
            if (item.test(data.stack.method_7909())) {
                pose.poseItem(pRenderer);
                flag.set(pose.overrideItemTransform());
            }
        });
        return flag.get();
    }

    public static void offhandCapture(PoseData data, class_1799 pStack, class_4587 pMatrixStack, class_4597 pBuffer, int pCombinedLight, float pEquippedProgress, float pSwingProgress, class_1306 pSide, class_759 pRenderer) {
        for (Map.Entry<Predicate<class_1792>, ExtendedPose> pose : PoseRegistry.poses.entrySet()) {
            if (pose.getKey().test(pStack.method_7909())) {
                pose.getValue().data = data;
                if (pose.getValue().forceRenderMainHand()) {
                    pMatrixStack.method_22903();
                    pose.getValue().poseMainHandFirstPerson(pMatrixStack);
                    pRenderer.method_3219(pMatrixStack, pBuffer, pCombinedLight, pEquippedProgress, pSwingProgress, class_310.method_1551().field_1724.method_6068());
                    pMatrixStack.method_22909();
                }
                if (pose.getValue().forceRenderOffhand()) {
                    pMatrixStack.method_22903();
                    pose.getValue().poseOffHandFirstPerson(pMatrixStack);
                    pRenderer.method_3219(pMatrixStack, pBuffer, pCombinedLight, pEquippedProgress, pSwingProgress, class_310.method_1551().field_1724.method_6068().method_5928());
                    pMatrixStack.method_22909();
                }
            }
        }
    }
}
