package foundry.veil.fabric.mixin.client.deferred.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.impl.client.render.deferred.DeferredShaderStateCache;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_284;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_761;

@Mixin(class_761.class)
public class LevelRendererMixin {

    @Unique
    private final DeferredShaderStateCache veil$cloudCache = new DeferredShaderStateCache();

    // Add custom cloud shader
    @ModifyArg(method = "renderClouds", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShader(Ljava/util/function/Supplier;)V"))
    public Supplier<class_5944> setCloudShader(Supplier<class_5944> supplier) {
        return () -> this.veil$cloudCache.getShader(VeilVanillaShaders.getClouds());
    }

    @Inject(method = "renderChunkLayer", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;getShader()Lnet/minecraft/client/renderer/ShaderInstance;", shift = At.Shift.AFTER))
    public void updateUniforms(class_1921 $$0, class_4587 $$1, double $$2, double $$3, double $$4, Matrix4f $$5, CallbackInfo ci) {
        class_5944 shader = RenderSystem.getShader();
        class_284 iModelViewMat = shader.method_34582("NormalMat");
        if (iModelViewMat != null) {
            iModelViewMat.method_39978($$1.method_23760().method_23761().normal(new Matrix3f()));
        }
    }
}
