/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.deferred.light;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import foundry.veil.api.client.render.deferred.light.renderer.InstancedLightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.VeilShaders;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL33C;

@ApiStatus.Internal
public class AreaLightRenderer
extends InstancedLightRenderer<AreaLight> {
    public AreaLightRenderer() {
        super(90);
    }

    @Override
    protected BufferBuilder.RenderedBuffer createMesh() {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        LightTypeRenderer.createInvertedCube((VertexConsumer)bufferBuilder);
        return bufferBuilder.end();
    }

    @Override
    protected void setupBufferState() {
        GL20C.glEnableVertexAttribArray((int)1);
        GL20C.glEnableVertexAttribArray((int)2);
        GL20C.glEnableVertexAttribArray((int)3);
        GL20C.glEnableVertexAttribArray((int)4);
        GL20C.glEnableVertexAttribArray((int)5);
        GL20C.glEnableVertexAttribArray((int)6);
        GL20C.glEnableVertexAttribArray((int)7);
        GL20C.glEnableVertexAttribArray((int)8);
        GL20C.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)this.lightSize, (long)0L);
        GL20C.glVertexAttribPointer((int)2, (int)4, (int)5126, (boolean)false, (int)this.lightSize, (long)16L);
        GL20C.glVertexAttribPointer((int)3, (int)4, (int)5126, (boolean)false, (int)this.lightSize, (long)32L);
        GL20C.glVertexAttribPointer((int)4, (int)4, (int)5126, (boolean)false, (int)this.lightSize, (long)48L);
        GL20C.glVertexAttribPointer((int)5, (int)3, (int)5126, (boolean)false, (int)this.lightSize, (long)64L);
        GL20C.glVertexAttribPointer((int)6, (int)2, (int)5126, (boolean)false, (int)this.lightSize, (long)76L);
        GL20C.glVertexAttribPointer((int)7, (int)1, (int)5123, (boolean)true, (int)this.lightSize, (long)84L);
        GL20C.glVertexAttribPointer((int)8, (int)1, (int)5126, (boolean)false, (int)this.lightSize, (long)86L);
        GL33C.glVertexAttribDivisor((int)1, (int)1);
        GL33C.glVertexAttribDivisor((int)2, (int)1);
        GL33C.glVertexAttribDivisor((int)3, (int)1);
        GL33C.glVertexAttribDivisor((int)4, (int)1);
        GL33C.glVertexAttribDivisor((int)5, (int)1);
        GL33C.glVertexAttribDivisor((int)6, (int)1);
        GL33C.glVertexAttribDivisor((int)7, (int)1);
        GL33C.glVertexAttribDivisor((int)8, (int)1);
    }

    @Override
    protected void setupRenderState(@NotNull LightRenderer lightRenderer, @NotNull List<AreaLight> lights) {
        VeilRenderSystem.setShader(VeilShaders.LIGHT_AREA);
    }

    @Override
    protected void clearRenderState(@NotNull LightRenderer lightRenderer, @NotNull List<AreaLight> lights) {
    }

    @Override
    protected boolean isVisible(AreaLight light, CullFrustum frustum) {
        Vector2f size = light.getSize();
        float distance = light.getDistance();
        Vector3d position = light.getPosition();
        float radius = Math.max(size.x, size.y) + distance;
        double minX = position.x - (double)radius;
        double minY = position.y - (double)radius;
        double minZ = position.z - (double)radius;
        double maxX = position.x + (double)radius;
        double maxY = position.y + (double)radius;
        double maxZ = position.z + (double)radius;
        return frustum.testAab(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

