/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric.platform;

import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FabricRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> key, String modId) {
        Registry reg = (Registry)BuiltInRegistries.REGISTRY.get(key.location());
        if (reg == null) {
            reg = FabricRegistryBuilder.createSimple(key).buildAndRegister();
        }
        return new Provider(modId, reg);
    }

    @Override
    public <T> RegistrationProvider<T> create(Registry<T> registry, String modId) {
        return new Provider<T>(modId, registry);
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final Registry<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, Registry<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public <I extends T> RegistryObject<I> register(final ResourceLocation id, Supplier<? extends I> supplier) {
            RegistryObject old = (RegistryObject)this.registry.get(id);
            if (old != null) {
                return old;
            }
            final Object obj = Registry.register(this.registry, (ResourceLocation)id, supplier.get());
            final ResourceKey key = ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)id);
            RegistryObject ro = new RegistryObject<I>(){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return key;
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return true;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public Holder<I> asHolder() {
                    return registry.getHolderOrThrow(key);
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public Registry<T> asVanillaRegistry() {
            return this.registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

