/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.Veil;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.fx.Trail;
import foundry.veil.api.quasar.particle.QuasarParticle;
import foundry.veil.api.quasar.particle.SpriteData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4fc;

public class RenderData {
    @Deprecated
    private static final ResourceLocation BLANK = Veil.veilPath("textures/special/blank.png");
    private final Vector3d prevPosition = new Vector3d();
    private final Vector3d renderPosition = new Vector3d();
    private final Vector3f prevRotation = new Vector3f();
    private final Vector3f renderRotation = new Vector3f();
    private float prevRadius = 1.0f;
    private float renderRadius = 1.0f;
    private int lightColor = 0xF000F0;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;
    public float renderAge = 0.0f;
    public float agePercent;
    private final boolean additive;
    private SpriteData spriteData;
    private TextureAtlasSprite atlasSprite;
    private RenderType renderType;
    private final List<Trail> trails;

    public RenderData(QuasarParticleData data) {
        this.additive = data.additive();
        this.spriteData = data.spriteData();
        this.atlasSprite = null;
        this.updateRenderType();
        this.trails = new ArrayList<Trail>();
    }

    private void updateRenderType() {
        this.renderType = this.atlasSprite != null ? VeilRenderType.quasarParticle(this.atlasSprite.atlasLocation(), this.additive) : (this.spriteData != null ? VeilRenderType.quasarParticle(this.spriteData.sprite(), this.additive) : VeilRenderType.quasarParticle(BLANK, this.additive));
    }

    @ApiStatus.Internal
    public void tick(QuasarParticle particle, int lightColor) {
        this.prevPosition.set((Vector3dc)particle.getPosition());
        this.prevRotation.set((Vector3fc)particle.getRotation());
        this.prevRadius = particle.getRadius();
        this.lightColor = lightColor;
    }

    @ApiStatus.Internal
    public void render(QuasarParticle particle, float partialTicks) {
        this.prevPosition.lerp((Vector3dc)particle.getPosition(), (double)partialTicks, this.renderPosition);
        this.prevRotation.lerp((Vector3fc)particle.getRotation(), partialTicks, this.renderRotation);
        this.renderRadius = Mth.lerp((float)partialTicks, (float)this.prevRadius, (float)particle.getRadius());
        this.renderAge = (float)particle.getAge() + partialTicks;
        this.agePercent = Math.min(this.renderAge / (float)particle.getLifetime(), 1.0f);
    }

    public Vector3dc getRenderPosition() {
        return this.renderPosition;
    }

    public Vector3fc getRenderRotation() {
        return this.renderRotation;
    }

    public float getRenderRadius() {
        return this.renderRadius;
    }

    public float getRenderAge() {
        return this.renderAge;
    }

    public float getAgePercent() {
        return this.agePercent;
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Nullable
    public SpriteData getSpriteData() {
        return this.spriteData;
    }

    public TextureAtlasSprite getAtlasSprite() {
        return this.atlasSprite;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    public void renderTrails(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos, int packedLight) {
        if (this.trails.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        for (Trail trail : this.trails) {
            trail.pushRotatedPoint(new Vec3(this.prevPosition.x, this.prevPosition.y, this.prevPosition.z), new Vec3((double)this.prevRotation.x, (double)this.prevRotation.y, (double)this.prevRotation.z));
            trail.render(poseStack, bufferSource.getBuffer(VeilRenderType.quasarTrail(trail.getTexture())), packedLight);
        }
        poseStack.popPose();
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setColor(Vector4fc color) {
        this.red = color.x();
        this.green = color.y();
        this.blue = color.z();
        this.alpha = color.w();
    }

    public void setSpriteData(@Nullable SpriteData spriteData) {
        this.spriteData = spriteData;
        this.updateRenderType();
    }

    public void setAtlasSprite(@Nullable TextureAtlasSprite atlasSprite) {
        this.atlasSprite = atlasSprite;
        this.updateRenderType();
    }
}

