/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class Line {
    private Vec3[] points;
    private int color;
    private Function<Float, Float> widthFunction;
    private int length = 100;
    private boolean billboard = true;
    private TilingMode tilingMode = TilingMode.STRETCH;
    private int frequency = 1;
    private float minDistance = 0.0f;
    private ResourceLocation texture = null;
    private CurveMode curveMode = CurveMode.NONE;

    public Line(Vec3[] points, int color, Function<Float, Float> widthFunction) {
        this.points = points;
        this.color = color;
        this.widthFunction = widthFunction;
    }

    public Line(int color, Function<Float, Float> widthFunction) {
        this(new Vec3[]{Vec3.ZERO}, color, widthFunction);
    }

    public void setCurveMode(CurveMode curveMode) {
        this.curveMode = curveMode;
    }

    public void setTilingMode(TilingMode tilingMode) {
        this.tilingMode = tilingMode;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public void setPoints(Vec3[] points) {
        if (points.length > this.length) {
            Vec3[] newPoints = new Vec3[this.length];
            System.arraycopy(points, points.length - this.length, newPoints, 0, this.length);
            points = newPoints;
        }
        this.points = points;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setWidthFunction(Function<Float, Float> widthFunction) {
        this.widthFunction = widthFunction;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setBillboard(boolean billboard) {
        this.billboard = billboard;
    }

    public Vec3[] getPoints() {
        return this.points;
    }

    public int getColor() {
        return this.color;
    }

    public Function<Float, Float> getWidthFunction() {
        return this.widthFunction;
    }

    public int getLength() {
        return this.length;
    }

    public boolean getBillboard() {
        return this.billboard;
    }

    public TilingMode getTilingMode() {
        return this.tilingMode;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public CurveMode getCurveMode() {
        return this.curveMode;
    }

    public void addPoint(Vec3 point) {
        Vec3[] newPoints = new Vec3[this.points.length + 1];
        System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        newPoints[this.points.length] = point;
        this.points = newPoints;
    }

    public void removePoint(int index) {
        Vec3[] newPoints = new Vec3[this.points.length - 1];
        System.arraycopy(this.points, 0, newPoints, 0, index);
        System.arraycopy(this.points, index + 1, newPoints, index, this.points.length - index - 1);
        this.points = newPoints;
    }

    public Vec3[] setupCurvePoints() {
        return this.curveMode.curveFunction.apply(this.points, this.frequency);
    }

    public void render(PoseStack stack, VertexConsumer consumer, int light) {
        stack.pushPose();
        RenderSystem.disableCull();
        Vec3[] curvePoints = this.setupCurvePoints();
        Vector3f[][] corners = new Vector3f[curvePoints.length][2];
        for (int i = 0; i < curvePoints.length; ++i) {
            float width = this.widthFunction.apply(Float.valueOf((float)i / (float)(curvePoints.length - 1))).floatValue();
            Vector3f topOffset = new Vector3f(0.0f, width / 2.0f, 0.0f);
            Vector3f bottomOffset = new Vector3f(0.0f, -(width / 2.0f), 0.0f);
            if (this.billboard) {
                // empty if block
            }
            topOffset.add((float)curvePoints[i].x, (float)curvePoints[i].y, (float)curvePoints[i].z);
            bottomOffset.add((float)curvePoints[i].x, (float)curvePoints[i].y, (float)curvePoints[i].z);
            corners[i / this.frequency][0] = topOffset;
            corners[i / this.frequency][1] = bottomOffset;
        }
        this.renderPoints(stack, consumer, light, corners, this.color);
        RenderSystem.enableCull();
        stack.popPose();
    }

    private void renderPoints(PoseStack stack, VertexConsumer consumer, int light, Vector3f[][] corners, int color) {
        stack.pushPose();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        for (int i = 0; i < corners.length - 1; ++i) {
            Vector3f top = corners[i][0];
            Vector3f bottom = corners[i][1];
            Vector3f nextTop = corners[i + 1][0];
            Vector3f nextBottom = corners[i + 1][1];
            if (nextTop == null) {
                nextTop = top;
            }
            if (nextBottom == null) {
                nextBottom = bottom;
            }
            if (top == null || bottom == null) continue;
            float u = 0.0f;
            float u1 = 1.0f;
            if (this.tilingMode == TilingMode.STRETCH) {
                u = (float)i / (float)(corners.length - 1);
                u1 = (float)(i + 1) / (float)(corners.length - 1);
            }
            consumer.vertex(stack.last().pose(), bottom.x(), bottom.y(), bottom.z()).color(r, g, b, a).uv(u, 0.0f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
            consumer.vertex(stack.last().pose(), top.x(), top.y(), top.z()).color(r, g, b, a).uv(u, 1.0f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
            consumer.vertex(stack.last().pose(), nextTop.x(), nextTop.y(), nextTop.z()).color(r, g, b, a).uv(u1, 1.0f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
            consumer.vertex(stack.last().pose(), nextBottom.x(), nextBottom.y(), nextBottom.z()).color(r, g, b, a).uv(u1, 0.0f).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
        }
        stack.popPose();
    }

    public static enum TilingMode {
        NONE,
        STRETCH,
        REPEAT;

    }

    public static enum CurveMode {
        NONE((points, freq) -> points),
        BEZIER((points, freq) -> {
            Vec3[] curvePoints = new Vec3[(((Vec3[])points).length - 2) * freq];
            for (int i = 0; i < ((Vec3[])points).length - 1; ++i) {
                Vec3 p0 = points[i];
                Vec3 p1 = points[i + 1];
                Vec3 p2 = points[Math.min(i + 2, ((Vec3[])points).length - 1)];
                Vec3 p3 = points[Math.min(i + 3, ((Vec3[])points).length - 1)];
                for (int j = 0; j < freq; ++j) {
                    float t = (float)j / (float)freq.intValue();
                    float t2 = t * t;
                    float t3 = t2 * t;
                    float x = (float)(0.5 * (2.0 * p1.x() + (-p0.x() + p2.x()) * (double)t + (2.0 * p0.x() - 5.0 * p1.x() + 4.0 * p2.x() - p3.x()) * (double)t2 + (-p0.x() + 3.0 * p1.x() - 3.0 * p2.x() + p3.x()) * (double)t3));
                    float y = (float)(0.5 * (2.0 * p1.y() + (-p0.y() + p2.y()) * (double)t + (2.0 * p0.y() - 5.0 * p1.y() + 4.0 * p2.y() - p3.y()) * (double)t2 + (-p0.y() + 3.0 * p1.y() - 3.0 * p2.y() + p3.y()) * (double)t3));
                    float z = (float)(0.5 * (2.0 * p1.z() + (-p0.z() + p2.z()) * (double)t + (2.0 * p0.z() - 5.0 * p1.z() + 4.0 * p2.z() - p3.z()) * (double)t2 + (-p0.z() + 3.0 * p1.z() - 3.0 * p2.z() + p3.z()) * (double)t3));
                    curvePoints[i * freq.intValue() + j] = new Vec3((double)x, (double)y, (double)z);
                }
            }
            return curvePoints;
        }),
        CATMULL_ROM((points, freq) -> {
            Vec3[] curvePoints = new Vec3[((Vec3[])points).length * freq];
            for (int i = 0; i < ((Vec3[])points).length - 1; ++i) {
                Vec3 p0 = points[Math.max(i - 1, 0)];
                Vec3 p1 = points[i];
                Vec3 p2 = points[Math.min(i + 1, ((Vec3[])points).length - 1)];
                Vec3 p3 = points[Math.min(i + 2, ((Vec3[])points).length - 1)];
                for (int j = 0; j < freq; ++j) {
                    float t = (float)j / (float)freq.intValue();
                    float t2 = t * t;
                    float t3 = t2 * t;
                    float x = (float)(0.5 * (2.0 * p1.x() + (-p0.x() + p2.x()) * (double)t + (2.0 * p0.x() - 5.0 * p1.x() + 4.0 * p2.x() - p3.x()) * (double)t2 + (-p0.x() + 3.0 * p1.x() - 3.0 * p2.x() + p3.x()) * (double)t3));
                    float y = (float)(0.5 * (2.0 * p1.y() + (-p0.y() + p2.y()) * (double)t + (2.0 * p0.y() - 5.0 * p1.y() + 4.0 * p2.y() - p3.y()) * (double)t2 + (-p0.y() + 3.0 * p1.y() - 3.0 * p2.y() + p3.y()) * (double)t3));
                    float z = (float)(0.5 * (2.0 * p1.z() + (-p0.z() + p2.z()) * (double)t + (2.0 * p0.z() - 5.0 * p1.z() + 4.0 * p2.z() - p3.z()) * (double)t2 + (-p0.z() + 3.0 * p1.z() - 3.0 * p2.z() + p3.z()) * (double)t3));
                    curvePoints[i * freq.intValue() + j] = new Vec3((double)x, (double)y, (double)z);
                }
            }
            return curvePoints;
        });

        final BiFunction<Vec3[], Integer, Vec3[]> curveFunction;

        private CurveMode(BiFunction<Vec3[], Integer, Vec3[]> curveFunction) {
            this.curveFunction = curveFunction;
        }
    }

    public static enum RenderMode {
        FLAT,
        CUBOID;

    }
}

