/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;

public interface MatrixStack {
    public void clear();

    default public void translate(double x, double y, double z) {
        this.translate((float)x, (float)y, (float)z);
    }

    public void translate(float var1, float var2, float var3);

    public void rotate(Quaterniondc var1);

    public void rotate(Quaternionfc var1);

    default public void rotate(double angle, double x, double y, double z) {
        this.rotate((float)angle, (float)x, (float)y, (float)z);
    }

    public void rotate(float var1, float var2, float var3, float var4);

    default public void rotateXYZ(double x, double y, double z) {
        this.rotateXYZ((float)x, (float)y, (float)z);
    }

    public void rotateXYZ(float var1, float var2, float var3);

    default public void rotateZYX(double z, double y, double x) {
        this.rotateZYX((float)z, (float)y, (float)x);
    }

    public void rotateZYX(float var1, float var2, float var3);

    public void rotateAround(Quaterniondc var1, double var2, double var4, double var6);

    public void rotateAround(Quaternionfc var1, float var2, float var3, float var4);

    default public void applyScale(double xyz) {
        this.applyScale((float)xyz, (float)xyz, (float)xyz);
    }

    default public void applyScale(float xyz) {
        this.applyScale(xyz, xyz, xyz);
    }

    default public void applyScale(double x, double y, double z) {
        this.applyScale((float)x, (float)y, (float)z);
    }

    public void applyScale(float var1, float var2, float var3);

    default public void copy(PoseStack other) {
        this.copy(other.last());
    }

    default public void copy(MatrixStack other) {
        this.copy(other.pose());
    }

    default public void copy(PoseStack.Pose other) {
        PoseStack.Pose pose = this.pose();
        pose.pose().set((Matrix4fc)other.pose());
        pose.normal().set((Matrix3fc)other.normal());
    }

    default public void setIdentity() {
        PoseStack.Pose pose = this.pose();
        pose.pose().identity();
        pose.normal().identity();
    }

    public boolean isIdentity();

    public boolean isEmpty();

    public void matrixPush();

    public void matrixPop();

    public PoseStack.Pose pose();

    default public Matrix4f position() {
        return this.pose().pose();
    }

    default public Matrix3f normal() {
        return this.pose().normal();
    }
}

