/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.imgui;

import foundry.veil.Veil;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.render.VeilRenderSystem;
import imgui.ImFont;
import imgui.ImGui;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class VeilImGuiUtil {
    private static final ImGuiCharSink IM_GUI_CHAR_SINK = new ImGuiCharSink();
    private static final StringSplitter IM_GUI_SPLITTER = new StringSplitter((charId, style) -> VeilImGuiUtil.getStyleFont(style).getCharAdvance(charId));
    private static final ResourceLocation ICON_FONT = Veil.veilPath("remixicon");

    public static void tooltip(String text) {
        ImGui.textColored((int)-11184811, (String)"(?)");
        if (ImGui.isItemHovered()) {
            ImGui.beginTooltip();
            ImGui.pushTextWrapPos((float)((float)ImGui.getFontSize() * 35.0f));
            ImGui.textColored((int)-1, (String)text);
            ImGui.popTextWrapPos();
            ImGui.endTooltip();
        }
    }

    public static void setTooltip(FormattedText text) {
        ImGui.beginTooltip();
        VeilImGuiUtil.component(text);
        ImGui.endTooltip();
    }

    public static void component(FormattedText text) {
        VeilImGuiUtil.component(text, Float.POSITIVE_INFINITY);
    }

    public static void component(FormattedText text, float wrapWidth) {
        IM_GUI_CHAR_SINK.reset();
        for (FormattedCharSequence part : Language.getInstance().getVisualOrder(IM_GUI_SPLITTER.splitLines(text, (int)wrapWidth, Style.EMPTY))) {
            part.accept((FormattedCharSink)IM_GUI_CHAR_SINK);
            IM_GUI_CHAR_SINK.finish();
            ImGui.newLine();
        }
    }

    public static void icon(int code) {
        ImGui.pushFont((ImFont)VeilRenderSystem.renderer().getEditorManager().getFont(ICON_FONT, false, false));
        ImGui.text((String)("" + (char)code));
        ImGui.popFont();
    }

    public static void icon(int code, int color) {
        ImGui.pushFont((ImFont)VeilRenderSystem.renderer().getEditorManager().getFont(ICON_FONT, false, false));
        ImGui.textColored((int)color, (String)("" + (char)code));
        ImGui.popFont();
    }

    public static void textCentered(String text, float width) {
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + (width - ImGui.getFont().calcTextSizeAX((float)ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, text)) / 2.0f));
        ImGui.text((String)text);
    }

    public static void resourceLocation(ResourceLocation loc) {
        ImGui.beginGroup();
        ImGui.textColored((int)VeilImGuiUtil.colorOf(loc.getNamespace()), (String)(loc.getNamespace() + ":"));
        ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
        ImGui.sameLine();
        ImGui.text((String)loc.getPath());
        ImGui.popStyleVar();
        ImGui.endGroup();
        if (ImGui.beginPopupContextItem((String)("" + loc))) {
            if (ImGui.selectable((String)"##copy_location")) {
                ImGui.setClipboardText((String)loc.toString());
            }
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilImGuiUtil.icon(60305);
            ImGui.sameLine();
            ImGui.popStyleVar();
            ImGui.text((String)"Copy Location");
            ImGui.endPopup();
        }
    }

    public static int colorOf(String modid) {
        int color = (modid.hashCode() & 0xAAAAAA) + 0x444444;
        Color c = Color.of(0xFF | color << 8);
        c.mix(Color.WHITE.darkenCopy(0.4f), 0.35f);
        return c.getRGBA();
    }

    public static ImFont getStyleFont(Style style) {
        return VeilRenderSystem.renderer().getEditorManager().getFont(Style.DEFAULT_FONT.equals((Object)style.getFont()) ? EditorManager.DEFAULT_FONT : style.getFont(), style.isBold(), style.isItalic());
    }

    public static int getColor(int color) {
        float[] colors = ImGui.getStyle().getColors()[color];
        return (int)(colors[3] * 255.0f) << 24 | (int)(colors[0] * 255.0f) << 16 | (int)(colors[1] * 255.0f) << 8 | (int)(colors[2] * 255.0f);
    }

    public static StringSplitter getStringSplitter() {
        return IM_GUI_SPLITTER;
    }

    @ApiStatus.Internal
    private static class ImGuiCharSink
    implements FormattedCharSink {
        private ImFont font;
        private int textColor;
        private HoverEvent hoverEvent;
        private ClickEvent clickEvent;
        private final StringBuilder buffer = new StringBuilder();

        private ImGuiCharSink() {
            this.reset();
        }

        public void reset() {
            this.font = ImGui.getFont();
            this.textColor = VeilImGuiUtil.getColor(0);
            this.buffer.setLength(0);
            this.hoverEvent = null;
            this.clickEvent = null;
        }

        public boolean accept(int unknown, Style style, int codePoint) {
            int styleColor;
            ImFont font = VeilImGuiUtil.getStyleFont(style);
            int n = styleColor = style.getColor() != null ? style.getColor().getValue() : this.textColor;
            if (font != this.font || styleColor != this.textColor || style.getHoverEvent() != this.hoverEvent || style.getClickEvent() != this.clickEvent) {
                if (!this.buffer.isEmpty()) {
                    this.finish();
                }
                this.font = VeilImGuiUtil.getStyleFont(style);
                this.textColor = styleColor;
                this.hoverEvent = style.getHoverEvent();
                this.clickEvent = style.getClickEvent();
            }
            this.buffer.appendCodePoint(codePoint);
            return true;
        }

        public void finish() {
            if (!this.buffer.isEmpty()) {
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
                ImGui.pushFont((ImFont)this.font);
                ImGui.textColored((int)(0xFF000000 | (this.textColor & 0xFF0000) >> 16 | this.textColor & 0xFF00 | (this.textColor & 0xFF) << 16), (String)this.buffer.toString());
                if (ImGui.isItemClicked() && this.clickEvent != null) {
                    this.handleClick();
                }
                if (ImGui.isItemHovered() && this.hoverEvent != null) {
                    this.handleHover();
                }
                ImGui.sameLine();
                ImGui.popFont();
                ImGui.popStyleVar();
                this.buffer.setLength(0);
            }
        }

        private void handleClick() {
            Minecraft minecraft = Minecraft.getInstance();
            String value = this.clickEvent.getValue();
            if (this.clickEvent.getAction() == ClickEvent.Action.OPEN_URL) {
                try {
                    URI uri = new URI(value);
                    String scheme = uri.getScheme();
                    if (scheme == null) {
                        throw new URISyntaxException(value, "Missing protocol");
                    }
                    if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                        throw new URISyntaxException(value, "Unsupported protocol: " + scheme.toLowerCase(Locale.ROOT));
                    }
                    Util.getPlatform().openUri(uri);
                }
                catch (URISyntaxException e) {
                    Veil.LOGGER.error("Can't open url for {}", (Object)this.clickEvent, (Object)e);
                }
                return;
            }
            if (this.clickEvent.getAction() == ClickEvent.Action.OPEN_FILE) {
                Util.getPlatform().openUri(new File(value).toURI());
                return;
            }
            if (this.clickEvent.getAction() == ClickEvent.Action.SUGGEST_COMMAND) {
                return;
            }
            if (this.clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
                return;
            }
            if (this.clickEvent.getAction() == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                minecraft.keyboardHandler.setClipboard(value);
                return;
            }
            Veil.LOGGER.error("Don't know how to handle {}", (Object)this.clickEvent);
        }

        private void handleHover() {
            Minecraft minecraft = Minecraft.getInstance();
            HoverEvent.ItemStackInfo stack = (HoverEvent.ItemStackInfo)this.hoverEvent.getValue(HoverEvent.Action.SHOW_ITEM);
            if (stack != null) {
                ImGui.beginTooltip();
                List tooltip = Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)stack.getItemStack());
                for (Component line : tooltip) {
                    VeilImGuiUtil.component((FormattedText)line, (float)ImGui.getFontSize() * 35.0f);
                }
                ImGui.endTooltip();
                return;
            }
            HoverEvent.EntityTooltipInfo entity = (HoverEvent.EntityTooltipInfo)this.hoverEvent.getValue(HoverEvent.Action.SHOW_ENTITY);
            if (entity != null) {
                if (minecraft.options.advancedItemTooltips) {
                    ImGui.beginTooltip();
                    List tooltip = entity.getTooltipLines();
                    for (Component line : tooltip) {
                        VeilImGuiUtil.component((FormattedText)line, (float)ImGui.getFontSize() * 35.0f);
                    }
                    ImGui.endTooltip();
                }
                return;
            }
            Component showText = (Component)this.hoverEvent.getValue(HoverEvent.Action.SHOW_TEXT);
            if (showText != null) {
                ImGui.beginTooltip();
                VeilImGuiUtil.component((FormattedText)showText, (float)ImGui.getFontSize() * 35.0f);
                ImGui.endTooltip();
            }
        }
    }
}

