/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light.renderer;

import foundry.veil.Veil;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.IndirectLight;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.api.client.render.shader.definition.DynamicShaderBlock;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Set;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class IndirectLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    private static final int MIN_LIGHTS = 20;
    protected final int lightSize;
    protected final int highResSize;
    protected final int lowResSize;
    protected final int positionOffset;
    protected final int rangeOffset;
    protected int maxLights;
    private final class_291 vbo;
    private final int instancedVbo;
    private final int indirectVbo;
    private final int sizeVbo;
    private final DynamicShaderBlock<?> instancedBlock;
    private final DynamicShaderBlock<?> indirectBlock;
    private int visibleLights;

    public IndirectLightRenderer(int lightSize, int lowResSize, int positionOffset, int rangeOffset) {
        if (!IndirectLightRenderer.isSupported()) {
            throw new IllegalStateException("Indirect light renderer is not supported");
        }
        this.lightSize = lightSize;
        this.maxLights = 20;
        this.vbo = new class_291(class_291.class_8555.field_44793);
        this.instancedVbo = GL42C.glGenBuffers();
        this.indirectVbo = GL42C.glGenBuffers();
        if (VeilRenderSystem.computeSupported() && VeilRenderSystem.atomicCounterSupported()) {
            Veil.LOGGER.info("Using GPU Frustum Culling for {} renderer", (Object)this.getClass().getSimpleName());
            this.sizeVbo = GL42C.glGenBuffers();
            this.instancedBlock = ShaderBlock.wrapper(37074, this.instancedVbo);
            this.indirectBlock = ShaderBlock.wrapper(37074, this.indirectVbo);
            GL42C.glBindBuffer((int)37568, (int)this.sizeVbo);
            GL42C.glBufferData((int)37568, (long)4L, (int)35048);
            GL42C.glBindBuffer((int)37568, (int)0);
        } else {
            Veil.LOGGER.info("Using CPU Frustum Culling for {} renderer", (Object)this.getClass().getSimpleName());
            this.sizeVbo = 0;
            this.instancedBlock = null;
            this.indirectBlock = null;
        }
        this.vbo.method_1353();
        this.vbo.method_1352(this.createMesh());
        this.highResSize = VeilRenderSystem.getIndexCount(this.vbo) - lowResSize;
        this.lowResSize = lowResSize;
        this.positionOffset = positionOffset;
        this.rangeOffset = rangeOffset;
        GL42C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL42C.glBindBuffer((int)36671, (int)this.indirectVbo);
        this.initBuffers();
        GL42C.glBindBuffer((int)36671, (int)0);
        this.setupBufferState();
        GL42C.glBindBuffer((int)34962, (int)0);
        class_291.method_1354();
    }

    protected abstract class_287.class_7433 createMesh();

    protected abstract void setupBufferState();

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    private void initBuffers() {
        GL42C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
        GL42C.glBufferData((int)36671, (long)((long)this.maxLights * 4L * 5L), (int)35048);
        if (this.sizeVbo != 0) {
            this.instancedBlock.setSize((long)this.maxLights * (long)this.lightSize);
            this.indirectBlock.setSize((long)this.maxLights * 4L * 5L);
        }
    }

    private boolean shouldDrawHighResolution(T light, CullFrustum frustum) {
        float radius = ((IndirectLight)light).getRadius();
        return frustum.getPosition().distanceSquared((Vector3dc)((PositionedLight)light).getPosition()) <= (double)(radius * radius);
    }

    private boolean isVisible(T light, CullFrustum frustum) {
        Vector3d position = ((PositionedLight)light).getPosition();
        float radius = ((IndirectLight)light).getRadius();
        return frustum.testSphere(position.x, position.y, position.z, radius * 1.414f);
    }

    private void updateAllLights(List<T> lights) {
        ByteBuffer dataBuffer = MemoryUtil.memAlloc((int)(lights.size() * this.lightSize));
        for (int i = 0; i < lights.size(); ++i) {
            Light light = (Light)lights.get(i);
            light.clean();
            dataBuffer.position(i * this.lightSize);
            ((InstancedLight)((Object)light)).store(dataBuffer);
        }
        dataBuffer.rewind();
        GL42C.glBufferSubData((int)34962, (long)0L, (ByteBuffer)dataBuffer);
        MemoryUtil.memFree((Buffer)dataBuffer);
    }

    private int updateVisibility(List<T> lights, CullFrustum frustum) {
        if (this.sizeVbo != 0) {
            VeilRenderSystem.setShader(VeilShaders.LIGHT_INDIRECT_SPHERE);
            ShaderProgram shader = VeilRenderSystem.getShader();
            if (shader != null && shader.isCompute()) {
                try {
                    int plane2;
                    block22: {
                        MemoryStack stack = MemoryStack.stackPush();
                        try {
                            VeilRenderSystem.bind("VeilLightInstanced", this.instancedBlock);
                            VeilRenderSystem.bind("VeilLightIndirect", this.indirectBlock);
                            GL30C.glBindBufferRange((int)37568, (int)0, (int)this.sizeVbo, (long)0L, (long)4L);
                            GL42C.glBufferSubData((int)37568, (long)0L, (IntBuffer)stack.callocInt(1));
                            shader.setInt("HighResSize", this.highResSize);
                            shader.setInt("LowResSize", this.lowResSize);
                            shader.setInt("LightSize", this.lightSize / 4);
                            shader.setInt("PositionOffset", this.positionOffset);
                            shader.setInt("RangeOffset", this.rangeOffset);
                            Vector4fc[] planes = frustum.getPlanes();
                            float[] values = new float[4 * planes.length];
                            for (int i = 0; i < planes.length; ++i) {
                                Vector4fc plane2 = planes[i];
                                values[i * 4] = plane2.x();
                                values[i * 4 + 1] = plane2.y();
                                values[i * 4 + 2] = plane2.z();
                                values[i * 4 + 3] = plane2.w();
                            }
                            shader.setFloats("FrustumPlanes", values);
                            shader.bind();
                            GL43C.glDispatchCompute((int)Math.min(lights.size(), VeilRenderSystem.maxComputeWorkGroupCountX()), (int)1, (int)1);
                            GL42C.glMemoryBarrier((int)4608);
                            ShaderProgram.unbind();
                            IntBuffer counter = stack.mallocInt(1);
                            GL42C.glBindBuffer((int)37568, (int)this.sizeVbo);
                            GL42C.glGetBufferSubData((int)37568, (long)0L, (IntBuffer)counter);
                            GL42C.glBindBuffer((int)37568, (int)0);
                            plane2 = counter.get(0);
                            if (stack == null) break block22;
                        }
                        catch (Throwable planes) {
                            if (stack != null) {
                                try {
                                    stack.close();
                                }
                                catch (Throwable values) {
                                    planes.addSuppressed(values);
                                }
                            }
                            throw planes;
                        }
                        stack.close();
                    }
                    return plane2;
                }
                finally {
                    VeilRenderSystem.unbind(this.instancedBlock);
                    VeilRenderSystem.unbind(this.indirectBlock);
                    GL30C.glBindBufferRange((int)37568, (int)0, (int)0, (long)0L, (long)4L);
                }
            }
        }
        int count = 0;
        GL42C.glBindBuffer((int)36671, (int)this.indirectVbo);
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buffer = stack.malloc(this.lowResSize > 0 ? 20 : 4);
            int index = 0;
            for (Light light : lights) {
                if (this.isVisible(light, frustum)) {
                    if (this.lowResSize > 0) {
                        boolean highRes = this.shouldDrawHighResolution(light, frustum);
                        buffer.putInt(0, highRes ? this.highResSize : this.lowResSize);
                        buffer.putInt(4, 1);
                        buffer.putInt(8, !highRes ? this.highResSize : 0);
                        buffer.putInt(12, 0);
                        buffer.putInt(16, index);
                        GL42C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L), (ByteBuffer)buffer);
                    } else {
                        buffer.putInt(0, index);
                        GL42C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L + 16L), (ByteBuffer)buffer);
                    }
                    ++count;
                }
                ++index;
            }
        }
        return count;
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, List<T> lights, Set<T> removedLights, CullFrustum frustum) {
        GL42C.glBindBuffer((int)34962, (int)this.instancedVbo);
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("resize");
        boolean rebuild = false;
        if (lights.size() > this.maxLights) {
            rebuild = true;
            this.maxLights = (int)Math.max(Math.max(Math.ceil((double)this.maxLights / 2.0), 20.0), (double)lights.size() * 1.5);
            GL42C.glBindBuffer((int)36671, (int)this.indirectVbo);
            this.initBuffers();
            GL42C.glBindBuffer((int)36671, (int)0);
        }
        profiler.method_15405("update");
        if (rebuild || !removedLights.isEmpty()) {
            this.updateAllLights(lights);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer buffer = stack.malloc(this.lightSize);
                for (int i = 0; i < lights.size(); ++i) {
                    Light light = (Light)lights.get(i);
                    if (!light.isDirty()) continue;
                    light.clean();
                    ((InstancedLight)((Object)light)).store(buffer);
                    buffer.rewind();
                    GL42C.glBufferSubData((int)34962, (long)((long)i * (long)this.lightSize), (ByteBuffer)buffer);
                }
            }
        }
        GL42C.glBindBuffer((int)34962, (int)0);
        profiler.method_15405("visibility");
        this.visibleLights = !lights.isEmpty() ? this.updateVisibility(lights, frustum) : 0;
        profiler.method_15407();
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights) {
        if (this.visibleLights <= 0) {
            return;
        }
        this.vbo.method_1353();
        GL42C.glBindBuffer((int)36671, (int)this.indirectVbo);
        this.setupRenderState(lightRenderer, lights);
        lightRenderer.applyShader();
        VeilRenderSystem.drawIndirect(this.vbo, 0L, this.visibleLights, 0);
        this.clearRenderState(lightRenderer, lights);
        GL42C.glBindBuffer((int)36671, (int)0);
        class_291.method_1354();
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights;
    }

    public void free() {
        this.vbo.close();
        GL42C.glDeleteBuffers((int)this.instancedVbo);
        GL42C.glDeleteBuffers((int)this.indirectVbo);
        if (this.sizeVbo != 0) {
            GL42C.glDeleteBuffers((int)this.sizeVbo);
            this.instancedBlock.free();
            this.indirectBlock.free();
        }
    }

    public static boolean isSupported() {
        GLCapabilities caps = GL.getCapabilities();
        return caps.OpenGL43 || caps.GL_ARB_multi_draw_indirect;
    }
}

