package foundry.veil.api.client.graveyard.render;

import foundry.veil.api.client.graveyard.AnimationProperties;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import foundry.veil.api.client.graveyard.skeleton.SkeletonFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;

public abstract class InterpolatedEntityRenderer<T extends class_1309 & InterpolatedSkeletonParent, S extends InterpolatedSkeleton> extends class_897<T> {

    protected final SkeletonFactory<S> modelFactory;
    private final List<InterpolatedEntityRenderLayer<T, S>> layers = new ArrayList<>();

    protected InterpolatedEntityRenderer(class_5617.class_5618 pContext, SkeletonFactory<S> modelFactory, float shadowRadius) {
        super(pContext);
        this.modelFactory = modelFactory;
        this.field_4673 = shadowRadius;
    }

    public void setupModelFactory(T parent) {
    }

    public final void createSkeleton(T parent) {
        this.setupModelFactory(parent);
        parent.setSkeleton(this.modelFactory.create());
    }

    public final boolean addLayer(InterpolatedEntityRenderLayer<T, S> layer) {
        return this.layers.add(layer);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void render(T entity, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(0.0625F, 0.0625F, 0.0625F);
        this.setupRotations(entity, poseStack, entity.field_6012 + partialTicks, partialTicks);

        class_310 minecraft = class_310.method_1551();
        boolean invisible = entity.method_5767();
        boolean isSpectatorTransparent = !invisible && !entity.method_5756(minecraft.field_1724);
        boolean glowing = minecraft.method_27022(entity);
        class_1921 rendertype = this.getRenderType(entity, invisible, isSpectatorTransparent, glowing);
        if (rendertype != null) {
            this.renderModel(entity, partialTicks, poseStack, buffer, packedLight);
        }

        InterpolatedSkeleton skeleton = entity.getSkeleton();
        if (!entity.method_7325()) {
            for (InterpolatedEntityRenderLayer<T, S> layer : this.layers) {
                if (skeleton != null) {
                    layer.render(poseStack, buffer, packedLight, entity, (S) skeleton, partialTicks);
                }
            }
        }

        if (skeleton != null) {
            skeleton.renderDebug(entity, poseStack, buffer, partialTicks);
        }

        poseStack.method_22909();
        super.method_3936(entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void renderModel(T pEntity, float pPartialTicks, class_4587 poseStack, class_4597 pBuffer, int pPackedLight) {
        InterpolatedSkeleton skeleton = pEntity.getSkeleton();
        if (skeleton == null) {
            return;
        }

        class_4588 vertexconsumer = pBuffer.getBuffer(this.getRenderType(pEntity));
        int packedOverlay = class_922.method_23622(pEntity, 0);
        skeleton.render(poseStack, vertexconsumer, pPackedLight, packedOverlay, pPartialTicks, 1.0F, 1.0F, 1.0F, 1.0F);
    }

    public abstract class_1921 getRenderType(T entity);

    protected class_1921 getRenderType(T pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        class_2960 resourcelocation = this.method_3931(pLivingEntity);
        if (pTranslucent) {
            return class_1921.method_29379(resourcelocation);
        } else if (pBodyVisible) {
            return this.getRenderType(pLivingEntity);
        } else {
            return pGlowing ? class_1921.method_23287(resourcelocation) : null;
        }
    }

    protected void setupRotations(T pEntityLiving, class_4587 pMatrixStack, float pAgeInTicks, float pPartialTicks) {
        if (pEntityLiving.field_6213 > 0) {
            float deathTime = ((float) pEntityLiving.field_6213 + pPartialTicks - 1.0F) / 20.0F * 1.6F;
            deathTime = class_3532.method_15355(deathTime);
            if (deathTime > 1.0F) {
                deathTime = 1.0F;
            }
            pMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(deathTime * this.getFlipDegrees(pEntityLiving)));
        } else if (pEntityLiving.method_6123()) {
            pMatrixStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0F - pEntityLiving.method_36455()));
            pMatrixStack.method_22907(class_7833.field_40716.rotationDegrees(((float) pEntityLiving.field_6012 + pPartialTicks) * -75.0F));
        } else if (class_922.method_38563(pEntityLiving)) {
            pMatrixStack.method_22904(0.0D, pEntityLiving.method_17682() + 0.1F, 0.0D);
            pMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0F));
        }
        if (pEntityLiving.method_32314()) {
            pMatrixStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15362(pEntityLiving.field_6012 * 3.25F) * class_3532.field_29844 * 0.4F));
        }
    }

    protected float getFlipDegrees(T entity) {
        return 90.0F;
    }

    public static void tick(List<InterpolatedSkeletonParent> entitiesToRender) {
        for (InterpolatedSkeletonParent interpolatedSkeletonParent : entitiesToRender) {
            AnimationProperties properties = new AnimationProperties();
            interpolatedSkeletonParent.getSkeleton().addAnimationProperties(properties, interpolatedSkeletonParent);
            interpolatedSkeletonParent.getSkeleton().tick(properties);
        }

        // TODO: MULTITHREAD ANIMATION CALCULATION AND EXECUTION?
//        ThreadPoolExecutor executor = (ThreadPoolExecutor) Executors.newCachedThreadPool();
//        for (InterpolatedSkeletonParent interpolatedSkeletonParent : entitiesToRender) {
//            executor.submit(new UpdateEntityTask(interpolatedSkeletonParent));
//        }
//
//        //maximum time of 1 tick
//        try {
//            executor.awaitTermination(50, TimeUnit.MILLISECONDS);
//        } catch (InterruptedException e) {
//            Clinker.LOGGER.warn("! Abandoned animation task early !");
//            Clinker.LOGGER.warn(e.getLocalizedMessage());
//        }
    }

//    private record UpdateEntityTask(InterpolatedSkeletonParent animator) implements Runnable {
//        @Override
//        public void run() {
//            AnimationProperties properties = new AnimationProperties();
//            animator.getSkeleton().addAnimationProperties(properties, animator);
//            animator.getSkeleton().tick(properties);
//        }
//    }
}
