/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.platform.registry;

import foundry.veil.platform.registry.RegistryObject;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface RegistrationProvider<T> {
    public static final Factory FACTORY = ServiceLoader.load(Factory.class).findFirst().orElseThrow(() -> new RuntimeException("Failed to load registration provider"));

    public static <T> RegistrationProvider<T> get(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        return FACTORY.create(resourceKey, modId);
    }

    public static <T> RegistrationProvider<T> get(Registry<T> registry, String modId) {
        return FACTORY.create(registry, modId);
    }

    default public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
        return this.register(new ResourceLocation(this.getModId(), name), supplier);
    }

    public <I extends T> RegistryObject<I> register(ResourceLocation var1, Supplier<? extends I> var2);

    public Collection<RegistryObject<T>> getEntries();

    public Registry<T> asVanillaRegistry();

    public String getModId();

    public static interface Factory {
        public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> var1, String var2);

        default public <T> RegistrationProvider<T> create(Registry<T> registry, String modId) {
            return this.create(registry.key(), modId);
        }
    }
}

