/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.client.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.ext.VertexBufferExtension;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL43C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VertexBuffer.class})
public abstract class VertexBufferMixin
implements VertexBufferExtension {
    @Shadow
    private VertexFormat.Mode mode;
    @Shadow
    private int indexBufferId;
    @Shadow
    private int indexCount;
    @Shadow
    @Nullable
    private RenderSystem.AutoStorageIndexBuffer sequentialIndices;
    @Shadow
    private VertexFormat.IndexType indexType;

    @Shadow
    protected abstract VertexFormat.IndexType getIndexType();

    @Override
    public void veil$drawInstanced(int instances) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._veil$drawInstanced(instances));
        } else {
            this._veil$drawInstanced(instances);
        }
    }

    @Override
    public void veil$drawIndirect(long indirect, int drawCount, int stride) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._veil$drawIndirect(indirect, drawCount, stride));
        } else {
            this._veil$drawIndirect(indirect, drawCount, stride);
        }
    }

    @Override
    public int veil$getIndexCount() {
        return this.indexCount;
    }

    @Inject(method={"draw"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawPatches(CallbackInfo ci) {
        if (this.mode != VertexFormat.Mode.QUADS) {
            return;
        }
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader != null && shader.hasTesselation()) {
            GL11C.glDrawArrays((int)14, (int)0, (int)(this.indexCount * 4 / 6));
            ci.cancel();
        }
    }

    @ModifyArg(method={"draw"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;drawElements(III)V"), index=0)
    public int modifyDrawMode(int glMode) {
        return this.veil$getDrawMode(glMode);
    }

    @Unique
    private int veil$getDrawMode(int defaultMode) {
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader != null && shader.hasTesselation()) {
            return 14;
        }
        return defaultMode;
    }

    @Unique
    private void _veil$drawInstanced(int instances) {
        ShaderProgram shader;
        if (this.mode == VertexFormat.Mode.QUADS && (shader = VeilRenderSystem.getShader()) != null && shader.hasTesselation()) {
            GL31C.glDrawArraysInstanced((int)14, (int)0, (int)(this.indexCount * 4 / 6), (int)instances);
            return;
        }
        GL31C.glDrawElementsInstanced((int)this.veil$getDrawMode(this.mode.asGLMode), (int)this.indexCount, (int)this.getIndexType().asGLType, (long)0L, (int)instances);
    }

    @Unique
    private void _veil$drawIndirect(long indirect, int drawCount, int stride) {
        if (this.sequentialIndices != null) {
            this.sequentialIndices.bind(this.indexCount);
            GL43C.glMultiDrawElementsIndirect((int)this.veil$getDrawMode(this.mode.asGLMode), (int)this.sequentialIndices.type().asGLType, (long)indirect, (int)drawCount, (int)stride);
        } else {
            GL15C.glBindBuffer((int)34963, (int)this.indexBufferId);
            GL43C.glMultiDrawElementsIndirect((int)this.veil$getDrawMode(this.mode.asGLMode), (int)this.indexType.asGLType, (long)indirect, (int)drawCount, (int)stride);
        }
    }
}

