/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderBindingProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPredefinitionProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderVersionProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.impl.client.render.pipeline.VeilShaderUploader;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class DirectShaderCompiler
implements ShaderCompiler {
    private final ResourceProvider provider;
    private final List<ShaderPreProcessor> processors;
    private final List<ShaderPreProcessor> importProcessors;
    private final Set<Integer> shaders;
    private ResourceLocation compilingName;
    private ShaderPreProcessor processor;
    private ShaderPreProcessor importProcessor;

    public DirectShaderCompiler(@Nullable ResourceProvider provider) {
        this.provider = provider;
        this.processors = new LinkedList<ShaderPreProcessor>();
        this.importProcessors = new LinkedList<ShaderPreProcessor>();
        this.shaders = new HashSet<Integer>();
    }

    private ShaderPreProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = ShaderPreProcessor.allOf(this.processors);
        }
        return this.processor;
    }

    private ShaderPreProcessor getImportProcessor() {
        if (this.importProcessor == null) {
            this.importProcessor = ShaderPreProcessor.allOf(this.importProcessors);
        }
        return this.importProcessor;
    }

    private void validateType(int type) throws ShaderException {
        if (type == 37305 && !VeilRenderSystem.computeSupported()) {
            throw new ShaderException("Compute is not supported", null);
        }
    }

    @Override
    public CompiledShader compile(ShaderCompiler.Context context, int type, ProgramDefinition.SourceType sourceType, ResourceLocation id) throws IOException, ShaderException {
        if (this.provider == null) {
            throw new IOException("Failed to read " + ShaderManager.getTypeName(type) + " from " + id + " because no provider was specified");
        }
        this.validateType(type);
        ResourceLocation location = context.sourceSet().getTypeConverter(type).idToFile(id);
        try {
            CompiledShader compiledShader;
            block10: {
                BufferedReader reader = this.provider.openAsReader(location);
                try {
                    this.compilingName = id;
                    compiledShader = this.compile(context, type, sourceType, IOUtils.toString((Reader)reader));
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)reader).close();
            }
            return compiledShader;
        }
        finally {
            this.compilingName = null;
        }
    }

    @Override
    public CompiledShader compile(ShaderCompiler.Context context, int type, ProgramDefinition.SourceType sourceType, String source) throws IOException, ShaderException {
        this.validateType(type);
        ShaderPreProcessor processor = this.getProcessor();
        ShaderPreProcessor importProcessor = this.getImportProcessor();
        processor.prepare();
        importProcessor.prepare();
        Object2IntArrayMap uniformBindings = new Object2IntArrayMap();
        HashSet<String> dependencies = new HashSet<String>();
        HashSet<ResourceLocation> includes = new HashSet<ResourceLocation>();
        Set<ResourceLocation> includesView = Collections.unmodifiableSet(includes);
        String transformed = processor.modify(new PreProcessorContext(importProcessor, context, (Map<String, Integer>)uniformBindings, dependencies, includes, includesView, this.compilingName, true), source);
        int shader = GL20C.glCreateShader((int)type);
        switch (sourceType) {
            case GLSL: {
                GlStateManager.glShaderSource((int)shader, List.of(transformed));
                break;
            }
            case GLSL_SPIRV: {
                VeilShaderUploader.get().compile(shader, type, (String)(this.compilingName != null ? this.compilingName.toString() : "Shader #" + context), transformed, false);
                break;
            }
            case HLSL_SPIRV: {
                VeilShaderUploader.get().compile(shader, type, (String)(this.compilingName != null ? this.compilingName.toString() : "Shader #" + context), transformed, true);
                break;
            }
            case SPIRV: {
                throw new UnsupportedOperationException("TODO implement");
            }
        }
        GL20C.glCompileShader((int)shader);
        if (GL20C.glGetShaderi((int)shader, (int)35713) != 1) {
            Object log = GL20C.glGetShaderInfoLog((int)shader);
            if (Veil.VERBOSE_SHADER_ERRORS) {
                log = (String)log + "\n" + transformed;
            }
            GL20C.glDeleteShader((int)shader);
            throw new ShaderException("Failed to compile " + ShaderManager.getTypeName(type) + " shader", (String)log);
        }
        this.shaders.add(shader);
        return new CompiledShader(this.compilingName, shader, (Object2IntMap<String>)Object2IntMaps.unmodifiable((Object2IntMap)uniformBindings), Collections.unmodifiableSet(dependencies), includesView);
    }

    @Override
    public ShaderCompiler addPreprocessor(ShaderPreProcessor processor, boolean modifyImports) {
        this.processors.add(processor);
        this.processor = null;
        if (modifyImports) {
            this.importProcessors.add(processor);
            this.importProcessor = null;
        }
        return this;
    }

    @Override
    public ShaderCompiler addDefaultProcessors() {
        if (this.provider != null) {
            this.addPreprocessor(new ShaderImportProcessor(this.provider));
        }
        this.addPreprocessor(new ShaderBindingProcessor());
        this.addPreprocessor(new ShaderPredefinitionProcessor(), false);
        this.addPreprocessor(new ShaderVersionProcessor(), false);
        return this;
    }

    public void free() {
        this.processors.clear();
        this.importProcessors.clear();
        this.shaders.forEach(GL20C::glDeleteShader);
        this.shaders.clear();
    }

    private record PreProcessorContext(ShaderPreProcessor preProcessor, ShaderCompiler.Context context, Map<String, Integer> uniformBindings, Set<String> dependencies, Set<ResourceLocation> includes, Set<ResourceLocation> includesView, @Nullable ResourceLocation name, boolean sourceFile) implements ShaderPreProcessor.Context
    {
        private final Set<ResourceLocation> includes;

        @Override
        public String modify(@Nullable ResourceLocation name, String source) throws IOException {
            PreProcessorContext context = new PreProcessorContext(this.preProcessor, this.context, this.uniformBindings, this.dependencies, this.includes, this.includesView, name, false);
            return this.preProcessor.modify(context, source);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            this.uniformBindings.put(name, binding);
        }

        @Override
        public void addDefinitionDependency(String name) {
            this.dependencies.add(name);
        }

        @Override
        public void addInclude(ResourceLocation name) {
            this.includes.add(name);
        }

        @Override
        public Set<ResourceLocation> includes() {
            return this.includesView;
        }

        @Override
        public boolean isSourceFile() {
            return this.sourceFile;
        }

        @Override
        @Nullable
        public ProgramDefinition definition() {
            return this.context.definition();
        }

        @Override
        public ShaderPreDefinitions preDefinitions() {
            return this.context.preDefinitions();
        }
    }
}

