/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.fabric.FabricQuasarParticleHandler;
import foundry.veil.fabric.mixin.compat.iris.NewWorldRenderingPipelineAccessor;
import foundry.veil.fabric.mixin.compat.sodium.RenderSectionManagerAccessor;
import foundry.veil.fabric.mixin.compat.sodium.ShaderChunkRendererAccessor;
import foundry.veil.fabric.mixin.compat.sodium.SodiumWorldRendererAccessor;
import foundry.veil.fabric.util.FabricReloadListener;
import foundry.veil.impl.VeilBuiltinPacks;
import foundry.veil.impl.VeilReloadListeners;
import foundry.veil.impl.client.render.VeilUITooltipRenderer;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import foundry.veil.impl.compat.IrisShaderMap;
import foundry.veil.impl.compat.SodiumShaderMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Collections;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        VeilClient.init();
        HudRenderCallback.EVENT.register((matrices, tickDelta) -> {
            Minecraft client = Minecraft.getInstance();
            VeilUITooltipRenderer.renderOverlay(client.gui, matrices, tickDelta, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> VeilClient.tickClient(client.getFrameTime()));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> client.execute(VeilRenderSystem.renderer().getDeferredRenderer()::reset));
        FabricQuasarParticleHandler.init();
        if (IrisShaderMap.isEnabled()) {
            IrisShaderMap.setLoadedShadersSupplier(() -> {
                WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
                if (pipeline instanceof NewWorldRenderingPipelineAccessor) {
                    return ((NewWorldRenderingPipelineAccessor)pipeline).getLoadedShaders();
                }
                return Collections.emptySet();
            });
        }
        if (SodiumShaderMap.isEnabled()) {
            SodiumShaderMap.setLoadedShadersSupplier(() -> {
                ChunkRenderer patt4372$temp;
                RenderSectionManagerAccessor renderSectionManager;
                SodiumWorldRenderer worldRenderer = SodiumWorldRenderer.instanceNullable();
                if (worldRenderer != null && (renderSectionManager = (RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager()) != null && (patt4372$temp = renderSectionManager.getChunkRenderer()) instanceof ShaderChunkRendererAccessor) {
                    ShaderChunkRendererAccessor accessor = (ShaderChunkRendererAccessor)patt4372$temp;
                    return Object2IntMaps.singleton((Object)new ResourceLocation("sodium", "chunk_shader"), (int)accessor.getPrograms().values().iterator().next().handle());
                }
                return Object2IntMaps.emptyMap();
            });
        }
        KeyBindingHelper.registerKeyBinding((KeyMapping)VeilClient.EDITOR_KEY);
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("veil").orElseThrow();
        VeilBuiltinPacks.registerPacks((id, defaultEnabled) -> ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)id, (ModContainer)container, (ResourcePackActivationType)(defaultEnabled ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL)));
        CoreShaderRegistrationCallback.EVENT.register(context -> {
            VeilVanillaShaders.free();
            VeilVanillaShaders.registerShaders((arg_0, arg_1, arg_2) -> ((CoreShaderRegistrationCallback.RegistrationContext)context).register(arg_0, arg_1, arg_2));
        });
        VeilReloadListeners.registerListeners((type, id, listener) -> ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener(Veil.veilPath(id), listener)));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)"quasar");
            builder.then(ClientCommandManager.argument((String)"emitter", (ArgumentType)ResourceLocationArgument.id()).suggests(QuasarParticles.emitterSuggestionProvider()).then(ClientCommandManager.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> {
                ResourceLocation id = (ResourceLocation)ctx.getArgument("emitter", ResourceLocation.class);
                FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
                ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
                ParticleEmitter instance = particleManager.createEmitter(id);
                if (instance == null) {
                    source.sendError((Component)Component.literal((String)("Unknown emitter: " + id)));
                    return 0;
                }
                WorldCoordinates coordinates = (WorldCoordinates)ctx.getArgument("position", WorldCoordinates.class);
                Vec3 pos = coordinates.getPosition(source.getEntity().createCommandSourceStack());
                instance.setPosition(pos.x, pos.y, pos.z);
                particleManager.addParticleSystem(instance);
                source.sendFeedback((Component)Component.literal((String)("Spawned " + id)));
                return 1;
            })));
            dispatcher.register(builder);
        });
        ClientTickEvents.START_WORLD_TICK.register(client -> VeilRenderSystem.renderer().getParticleManager().tick());
    }
}

