/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilVertexFormat;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.mixin.accessor.RenderTypeAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

public final class VeilRenderType
extends RenderType {
    private static final RenderStateShard.ShaderStateShard PARTICLE = VeilRenderBridge.shaderState(VeilShaders.PARTICLE);
    private static final RenderStateShard.ShaderStateShard PARTICLE_ADD = VeilRenderBridge.shaderState(VeilShaders.PARTICLE_ADD);
    private static final RenderStateShard.ShaderStateShard SKINNED_MESH = VeilRenderBridge.shaderState(VeilShaders.SKINNED_MESH);
    private static final BiFunction<ResourceLocation, Boolean, RenderType> QUASAR_PARTICLE = Util.memoize((texture, additive) -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(additive != false ? PARTICLE_ADD : PARTICLE).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(additive != false ? ADDITIVE_TRANSPARENCY : TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setWriteMaskState(additive != false ? COLOR_WRITE : COLOR_DEPTH_WRITE).createCompositeState(false);
        return VeilRenderType.create((String)"veil:quasar_particle", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)false, (additive == false ? 1 : 0) != 0, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> QUASAR_TRAIL = Util.memoize(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(ADDITIVE_TRANSPARENCY).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).createCompositeState(false);
        return RenderType.create((String)"veil:quasar_trail", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> NECROMANCER_SKINNED_MESH = Util.memoize(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(SKINNED_MESH).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(NO_TRANSPARENCY).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true);
        return RenderType.create((String)"veil:skinned_mesh", (VertexFormat)VeilVertexFormat.SKINNED_MESH, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });

    public static RenderType quasarParticle(ResourceLocation texture, boolean additive) {
        return QUASAR_PARTICLE.apply(texture, additive);
    }

    public static RenderType quasarTrail(ResourceLocation texture) {
        return QUASAR_TRAIL.apply(texture);
    }

    public static RenderType layered(RenderType ... layers) {
        if (layers.length == 0) {
            throw new IllegalArgumentException("At least 1 render type must be specified");
        }
        if (layers.length == 1) {
            return layers[0];
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        VertexFormat format = layers[0].format();
        VertexFormat.Mode mode = layers[0].mode();
        int bufferSize = layers[0].bufferSize();
        boolean sortOnUpload = ((RenderTypeAccessor)layers[0]).isSortOnUpload();
        for (int i = 1; i < layers.length; ++i) {
            RenderType layer = layers[i];
            if (!layer.format().equals((Object)format)) {
                throw new IllegalArgumentException("Expected " + layer + " to use " + format + ", but was " + layer.format());
            }
            if (!layer.mode().equals((Object)mode)) {
                throw new IllegalArgumentException("Expected " + layer + " to use " + mode + ", but was " + layer.mode());
            }
            bufferSize = Math.max(bufferSize, layer.bufferSize());
            if (((RenderTypeAccessor)layer).isSortOnUpload()) {
                sortOnUpload = true;
            }
            builder.add((Object)layer);
        }
        return new LayeredRenderType(layers[0], (List<RenderType>)builder.build(), "LayeredRenderType[" + Arrays.stream(layers).map(RenderType::toString) + "]", bufferSize, sortOnUpload);
    }

    private VeilRenderType(String $$0, VertexFormat $$1, VertexFormat.Mode $$2, int $$3, boolean $$4, boolean $$5, Runnable $$6, Runnable $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    public static class LayeredRenderType
    extends RenderType {
        private final List<RenderType> layers;

        private LayeredRenderType(RenderType defaultValue, List<RenderType> layers, String name, int bufferSize, boolean sortOnUpload) {
            super(name, defaultValue.format(), defaultValue.mode(), bufferSize, defaultValue.affectsCrumbling(), sortOnUpload, () -> ((RenderType)defaultValue).setupRenderState(), () -> ((RenderType)defaultValue).clearRenderState());
            this.layers = layers;
        }

        public void end(BufferBuilder builder, VertexSorting sorting) {
            BufferUploader.invalidate();
            super.end(builder, sorting);
            if (BufferUploader.lastImmediateBuffer != null) {
                for (RenderType layer : this.layers) {
                    layer.setupRenderState();
                    ShaderInstance shader = RenderSystem.getShader();
                    shader.apply();
                    BufferUploader.lastImmediateBuffer.draw();
                    shader.clear();
                    layer.clearRenderState();
                }
            }
        }
    }
}

