/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.GameRendererExtension;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.impl.client.render.LevelPerspectiveCamera;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public final class VeilLevelPerspectiveRenderer {
    private static final LevelPerspectiveCamera CAMERA = new LevelPerspectiveCamera();
    private static final Matrix4f TRANSFORM = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private static final Matrix4f BACKUP_PROJECTION = new Matrix4f();
    private static final Matrix3f BACKUP_INVERSE_VIEW_ROTATION = new Matrix3f();
    private static final Vector3f BACKUP_LIGHT0_POSITION = new Vector3f();
    private static final Vector3f BACKUP_LIGHT1_POSITION = new Vector3f();
    private static boolean renderingPerspective = false;

    private VeilLevelPerspectiveRenderer() {
    }

    public static void render(AdvancedFbo framebuffer, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, float partialTicks) {
        VeilLevelPerspectiveRenderer.render(framebuffer, Minecraft.getInstance().cameraEntity, modelView, projection, cameraPosition, cameraOrientation, renderDistance, partialTicks);
    }

    public static void render(AdvancedFbo framebuffer, @Nullable Entity cameraEntity, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, float partialTicks) {
        if (renderingPerspective) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        GameRenderer gameRenderer = minecraft.gameRenderer;
        LevelRenderer levelRenderer = minecraft.levelRenderer;
        Window window = minecraft.getWindow();
        GameRendererAccessor accessor = (GameRendererAccessor)gameRenderer;
        RenderTargetExtension renderTargetExtension = (RenderTargetExtension)minecraft.getMainRenderTarget();
        long time = ((GameRendererExtension)gameRenderer).veil$getFrameStartNanos();
        CAMERA.setup(cameraPosition, cameraEntity, minecraft.level, cameraOrientation);
        PoseStack poseStack = new PoseStack();
        PoseStack.Pose pose = poseStack.last();
        poseStack.mulPoseMatrix(TRANSFORM.set(modelView));
        pose.normal().mul((Matrix3fc)TRANSFORM.normal(NORMAL));
        poseStack.mulPose(CAMERA.rotation());
        BACKUP_INVERSE_VIEW_ROTATION.set((Matrix3fc)RenderSystem.getInverseViewRotationMatrix());
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)NORMAL.rotate((Quaternionfc)CAMERA.rotation()).invert());
        float backupRenderDistance = gameRenderer.getRenderDistance();
        accessor.setRenderDistance(renderDistance);
        int backupWidth = window.getWidth();
        int backupHeight = window.getHeight();
        window.setWidth(framebuffer.getWidth());
        window.setHeight(framebuffer.getHeight());
        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        boolean backupEnabled = deferredRenderer.isEnabled();
        if (backupEnabled) {
            deferredRenderer.disable();
        }
        BACKUP_PROJECTION.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        gameRenderer.resetProjectionMatrix(TRANSFORM.set(projection));
        BACKUP_LIGHT0_POSITION.set(VeilRenderSystem.getLight0Position());
        BACKUP_LIGHT1_POSITION.set(VeilRenderSystem.getLight1Position());
        HitResult backupHitResult = minecraft.hitResult;
        Entity backupCrosshairPickEntity = minecraft.crosshairPickEntity;
        renderingPerspective = true;
        framebuffer.bindDraw(true);
        renderTargetExtension.veil$setWrapper(framebuffer);
        levelRenderer.prepareCullFrustum(poseStack, new Vec3(cameraPosition.x(), cameraPosition.y(), cameraPosition.z()), TRANSFORM);
        levelRenderer.renderLevel(poseStack, partialTicks, time, false, (Camera)CAMERA, gameRenderer, gameRenderer.lightTexture(), TRANSFORM);
        levelRenderer.doEntityOutline();
        renderTargetExtension.veil$setWrapper(null);
        AdvancedFbo.unbind();
        renderingPerspective = false;
        minecraft.crosshairPickEntity = backupCrosshairPickEntity;
        minecraft.hitResult = backupHitResult;
        RenderSystem.setShaderLights((Vector3f)BACKUP_LIGHT0_POSITION, (Vector3f)BACKUP_LIGHT1_POSITION);
        gameRenderer.resetProjectionMatrix(BACKUP_PROJECTION);
        window.setWidth(backupWidth);
        window.setHeight(backupHeight);
        if (backupEnabled) {
            deferredRenderer.enable();
        }
        accessor.setRenderDistance(backupRenderDistance);
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)BACKUP_INVERSE_VIEW_ROTATION);
    }

    public static boolean isRenderingPerspective() {
        return renderingPerspective;
    }
}

