/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.GameRendererExtension;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.impl.client.render.LevelPerspectiveCamera;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public final class VeilLevelPerspectiveRenderer {
    private static final LevelPerspectiveCamera CAMERA = new LevelPerspectiveCamera();
    private static final Matrix4f TRANSFORM = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private static final Matrix4f BACKUP_PROJECTION = new Matrix4f();
    private static final Matrix3f BACKUP_INVERSE_VIEW_ROTATION = new Matrix3f();
    private static final Vector3f BACKUP_LIGHT0_POSITION = new Vector3f();
    private static final Vector3f BACKUP_LIGHT1_POSITION = new Vector3f();
    private static boolean renderingPerspective = false;

    private VeilLevelPerspectiveRenderer() {
    }

    public static void render(AdvancedFbo framebuffer, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, float partialTicks) {
        VeilLevelPerspectiveRenderer.render(framebuffer, class_310.method_1551().field_1719, modelView, projection, cameraPosition, cameraOrientation, renderDistance, partialTicks);
    }

    public static void render(AdvancedFbo framebuffer, @Nullable class_1297 cameraEntity, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, float partialTicks) {
        if (renderingPerspective) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_757 gameRenderer = minecraft.field_1773;
        class_761 levelRenderer = minecraft.field_1769;
        class_1041 window = minecraft.method_22683();
        GameRendererAccessor accessor = (GameRendererAccessor)gameRenderer;
        RenderTargetExtension renderTargetExtension = (RenderTargetExtension)minecraft.method_1522();
        long time = ((GameRendererExtension)gameRenderer).veil$getFrameStartNanos();
        CAMERA.setup(cameraPosition, cameraEntity, minecraft.field_1687, cameraOrientation);
        class_4587 poseStack = new class_4587();
        class_4587.class_4665 pose = poseStack.method_23760();
        poseStack.method_34425(TRANSFORM.set(modelView));
        pose.method_23762().mul((Matrix3fc)TRANSFORM.normal(NORMAL));
        poseStack.method_22907(CAMERA.method_23767());
        BACKUP_INVERSE_VIEW_ROTATION.set((Matrix3fc)RenderSystem.getInverseViewRotationMatrix());
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)NORMAL.rotate((Quaternionfc)CAMERA.method_23767()).invert());
        float backupRenderDistance = gameRenderer.method_3193();
        accessor.setRenderDistance(renderDistance);
        int backupWidth = window.method_4489();
        int backupHeight = window.method_4506();
        window.method_35642(framebuffer.getWidth());
        window.method_35643(framebuffer.getHeight());
        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        boolean backupEnabled = deferredRenderer.isEnabled();
        if (backupEnabled) {
            deferredRenderer.disable();
        }
        BACKUP_PROJECTION.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        gameRenderer.method_22709(TRANSFORM.set(projection));
        BACKUP_LIGHT0_POSITION.set(VeilRenderSystem.getLight0Position());
        BACKUP_LIGHT1_POSITION.set(VeilRenderSystem.getLight1Position());
        class_239 backupHitResult = minecraft.field_1765;
        class_1297 backupCrosshairPickEntity = minecraft.field_1692;
        renderingPerspective = true;
        framebuffer.bindDraw(true);
        renderTargetExtension.veil$setWrapper(framebuffer);
        levelRenderer.method_32133(poseStack, new class_243(cameraPosition.x(), cameraPosition.y(), cameraPosition.z()), TRANSFORM);
        levelRenderer.method_22710(poseStack, partialTicks, time, false, (class_4184)CAMERA, gameRenderer, gameRenderer.method_22974(), TRANSFORM);
        levelRenderer.method_3254();
        renderTargetExtension.veil$setWrapper(null);
        AdvancedFbo.unbind();
        renderingPerspective = false;
        minecraft.field_1692 = backupCrosshairPickEntity;
        minecraft.field_1765 = backupHitResult;
        RenderSystem.setShaderLights((Vector3f)BACKUP_LIGHT0_POSITION, (Vector3f)BACKUP_LIGHT1_POSITION);
        gameRenderer.method_22709(BACKUP_PROJECTION);
        window.method_35642(backupWidth);
        window.method_35643(backupHeight);
        if (backupEnabled) {
            deferredRenderer.enable();
        }
        accessor.setRenderDistance(backupRenderDistance);
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)BACKUP_INVERSE_VIEW_ROTATION);
    }

    public static boolean isRenderingPerspective() {
        return renderingPerspective;
    }
}

