/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light.renderer;

import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightTypeRenderer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_287;
import net.minecraft.class_291;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class InstancedLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    private static final int MAX_UPLOADS = 400;
    protected final int lightSize;
    protected int maxLights;
    private final List<T> visibleLights;
    private final class_291 vbo;
    private final int instancedVbo;

    public InstancedLightRenderer(int lightSize) {
        this.lightSize = lightSize;
        this.maxLights = 100;
        this.visibleLights = new ArrayList<T>();
        this.vbo = new class_291(class_291.class_8555.field_44793);
        this.instancedVbo = GL15C.glGenBuffers();
        this.vbo.method_1353();
        this.vbo.method_1352(this.createMesh());
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
        this.setupBufferState();
        GL15C.glBindBuffer((int)34962, (int)0);
        class_291.method_1354();
    }

    protected abstract class_287.class_7433 createMesh();

    protected abstract void setupBufferState();

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    protected abstract boolean isVisible(T var1, CullFrustum var2);

    private void updateAllLights(List<T> lights) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int pointer = 0;
            long offset = 0L;
            ByteBuffer dataBuffer = stack.malloc(Math.min(400, lights.size()) * this.lightSize);
            for (Light light : lights) {
                light.clean();
                dataBuffer.position(pointer++ * this.lightSize);
                ((InstancedLight)((Object)light)).store(dataBuffer);
                if (pointer < 400) continue;
                dataBuffer.rewind();
                GL15C.glBufferSubData((int)34962, (long)offset, (ByteBuffer)dataBuffer);
                offset += (long)dataBuffer.capacity();
                pointer = 0;
            }
            if (pointer > 0) {
                dataBuffer.rewind();
                GL15C.nglBufferSubData((int)34962, (long)offset, (long)((long)pointer * (long)this.lightSize), (long)MemoryUtil.memAddress((ByteBuffer)dataBuffer));
            }
        }
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, List<T> lights, Set<T> removedLights, CullFrustum frustum) {
        this.visibleLights.clear();
        for (Light light : lights) {
            if (!this.isVisible(light, frustum)) continue;
            this.visibleLights.add(light);
        }
        if (this.visibleLights.isEmpty()) {
            return;
        }
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        boolean rebuild = false;
        if (this.visibleLights.size() > this.maxLights) {
            rebuild = true;
            this.maxLights = (int)Math.max(Math.ceil((double)this.maxLights / 2.0), (double)this.visibleLights.size() * 1.5);
            GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35040);
        }
        if (rebuild || !removedLights.isEmpty()) {
            this.updateAllLights(this.visibleLights);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer buffer = stack.malloc(this.lightSize);
                for (int i = 0; i < this.visibleLights.size(); ++i) {
                    Light light = (Light)this.visibleLights.get(i);
                    if (!light.isDirty()) continue;
                    light.clean();
                    ((InstancedLight)((Object)light)).store(buffer);
                    buffer.rewind();
                    GL15C.glBufferSubData((int)34962, (long)((long)i * (long)this.lightSize), (ByteBuffer)buffer);
                }
            }
        }
        GL15C.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights) {
        if (this.visibleLights.isEmpty()) {
            return;
        }
        this.vbo.method_1353();
        this.setupRenderState(lightRenderer, this.visibleLights);
        lightRenderer.applyShader();
        VeilRenderSystem.drawInstanced(this.vbo, this.visibleLights.size());
        this.clearRenderState(lightRenderer, this.visibleLights);
        class_291.method_1354();
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights.size();
    }

    public void free() {
        this.vbo.close();
        GL15C.glDeleteBuffers((int)this.instancedVbo);
    }
}

