/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import foundry.veil.lib.asm.Label;
import foundry.veil.lib.asm.tree.MethodNode;
import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record TernaryOperationNode(Node value, Node left, Node right) implements Node
{
    @Override
    public String toString() {
        return this.value + " ? " + this.left + " : " + this.right;
    }

    @Override
    public boolean isConstant() {
        return this.value.isConstant();
    }

    @Override
    public boolean hasValue() {
        return this.left.hasValue() && this.right.hasValue();
    }

    @Override
    public float evaluate(MolangBytecodeEnvironment environment) throws MolangException {
        return this.value.evaluate(environment) != 0.0f ? this.left.evaluate(environment) : this.right.evaluate(environment);
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        Label label_right = new Label();
        Label label_end = new Label();
        if (environment.optimize() && this.value.isConstant()) {
            if (this.value.evaluate(environment) != 0.0f) {
                this.left.writeBytecode(method, environment, breakLabel, continueLabel);
                if (this.left.hasValue() && !this.hasValue()) {
                    method.visitInsn(87);
                }
            } else {
                this.right.writeBytecode(method, environment, breakLabel, continueLabel);
                if (this.right.hasValue() && !this.hasValue()) {
                    method.visitInsn(87);
                }
            }
            return;
        }
        this.value.writeBytecode(method, environment, breakLabel, continueLabel);
        method.visitInsn(11);
        method.visitInsn(149);
        method.visitJumpInsn(153, label_right);
        MolangBytecodeEnvironment localEnvironment = new MolangBytecodeEnvironment(environment);
        this.left.writeBytecode(method, localEnvironment, breakLabel, continueLabel);
        if (this.left.hasValue() && !this.hasValue()) {
            method.visitInsn(87);
        }
        localEnvironment.writeModifiedVariables(method);
        method.visitJumpInsn(167, label_end);
        method.visitLabel(label_right);
        localEnvironment = new MolangBytecodeEnvironment(environment);
        this.right.writeBytecode(method, environment, breakLabel, continueLabel);
        if (this.right.hasValue() && !this.hasValue()) {
            method.visitInsn(87);
        }
        localEnvironment.writeModifiedVariables(method);
        method.visitLabel(label_end);
    }
}

