/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.api;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangEnvironmentBuilder;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.api.object.ImmutableMolangObject;
import gg.moonflower.molangcompiler.api.object.MolangObject;
import gg.moonflower.molangcompiler.core.object.MolangVariableStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MolangRuntime
implements MolangEnvironment {
    private float thisValue = 0.0f;
    private final Map<String, MolangObject> objects = new HashMap<String, MolangObject>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final List<Float> parameters;

    private MolangRuntime(MolangObject query, MolangObject global, MolangObject variable, Map<String, MolangObject> libraries) {
        this.objects.putAll(libraries);
        this.loadLibrary("context", query, "c");
        this.loadLibrary("query", query, "q");
        this.loadLibrary("global", global);
        this.loadLibrary("variable", variable, "v");
        this.parameters = new ArrayList<Float>(8);
    }

    private String sanitize(String name) {
        name = name.toLowerCase(Locale.ROOT);
        while (this.aliases.containsKey(name)) {
            name = this.aliases.get(name).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    public String dump() {
        StringBuilder builder = new StringBuilder("==Start MoLang Runtime Dump==\n\n");
        builder.append("==Start Objects==\n");
        for (Map.Entry<String, MolangObject> entry : this.objects.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append("==End Objects==\n\n");
        builder.append("==Start Parameters==\n");
        for (int i = 0; i < this.parameters.size(); ++i) {
            builder.append("\tParameter ").append(i).append('=').append(this.parameters.get(i)).append('\n');
        }
        builder.append("==End Parameters==\n\n");
        builder.append("==End MoLang Runtime Dump==");
        return builder.toString();
    }

    @Override
    public void loadLibrary(String name, MolangObject object, String ... aliases) {
        this.objects.put(name.toLowerCase(Locale.ROOT), object);
        for (String alias : aliases) {
            this.aliases.put(alias, name);
        }
    }

    @Override
    public void loadAlias(String name, String first, String ... aliases) {
        if (!this.objects.containsKey(name)) {
            throw new IllegalArgumentException("Invalid MoLang library: " + name);
        }
        this.aliases.put(first, name);
        for (String alias : aliases) {
            this.aliases.put(alias, name);
        }
    }

    @Override
    public void loadParameter(float expression) {
        this.parameters.add(Float.valueOf(expression));
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public float getThis() {
        return this.thisValue;
    }

    @Override
    public MolangObject get(String name) throws MolangRuntimeException {
        MolangObject object = this.objects.get(name = this.sanitize(name));
        if (object != null) {
            return object;
        }
        throw new MolangRuntimeException("Unknown MoLang object: " + name);
    }

    @Override
    public float getParameter(int parameter) throws MolangRuntimeException {
        if (parameter < 0 || parameter >= this.parameters.size()) {
            throw new MolangRuntimeException("No parameter loaded in slot " + parameter);
        }
        return this.parameters.get(parameter).floatValue();
    }

    @Override
    public int getParameters() {
        return this.parameters.size();
    }

    @Override
    public Collection<String> getObjects() {
        return this.objects.keySet();
    }

    @Override
    public void setThisValue(float thisValue) {
        this.thisValue = thisValue;
    }

    @Override
    public boolean canEdit() {
        return true;
    }

    public MolangEnvironmentBuilder<MolangRuntime> edit() {
        MolangVariableStorage query = this.getStorage("query");
        MolangVariableStorage global = this.getStorage("global");
        MolangVariableStorage variable = this.getStorage("variable");
        return new EditBuilder(this, query, global, variable);
    }

    private MolangVariableStorage getStorage(String name) {
        MolangObject object = this.objects.get(name);
        if (object == null) {
            throw new IllegalStateException("Missing " + name);
        }
        if (object instanceof ImmutableMolangObject) {
            ImmutableMolangObject immutableObject = (ImmutableMolangObject)object;
            object = immutableObject.parent();
        }
        if (!(object instanceof MolangVariableStorage)) {
            throw new IllegalStateException("Expected " + name + " to be " + MolangVariableStorage.class.getName() + ", was " + object.getClass().getName());
        }
        MolangVariableStorage variableStorage = (MolangVariableStorage)object;
        return variableStorage;
    }

    public static Builder runtime() {
        return new Builder();
    }

    public static Builder runtime(Builder copy) {
        return new Builder(copy);
    }

    private record EditBuilder(MolangRuntime runtime, MolangVariableStorage query, MolangVariableStorage global, MolangVariableStorage variable) implements MolangEnvironmentBuilder<MolangRuntime>
    {
        @Override
        public MolangEnvironmentBuilder<MolangRuntime> loadLibrary(String name, MolangObject object) {
            this.runtime.loadLibrary(name, object);
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> unloadLibrary(String name) {
            MolangObject removed = this.runtime.objects.get(name);
            if (removed == this.query || removed == this.global || removed == this.variable) {
                throw new IllegalStateException("Cannot remove query, global, or variable");
            }
            this.runtime.objects.remove(name);
            return this;
        }

        private MolangEnvironmentBuilder<MolangRuntime> set(MolangObject object, String name, MolangExpression value) {
            try {
                object.set(name, value);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        private MolangEnvironmentBuilder<MolangRuntime> remove(MolangObject object, String name) {
            try {
                object.remove(name);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> setQuery(String name, MolangExpression value) {
            return this.set(this.query, name, value);
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> setGlobal(String name, MolangExpression value) {
            return this.set(this.global, name, value);
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> setVariable(String name, MolangExpression value) {
            return this.set(this.variable, name, value);
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> removeQuery(String name) {
            return this.remove(this.query, name);
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> removeGlobal(String name) {
            return this.remove(this.global, name);
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> removeVariable(String name) {
            return this.remove(this.variable, name);
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> clearLibraries() {
            this.runtime.objects.values().retainAll(List.of(this.query, this.global, this.variable));
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> clearQuery() {
            this.query.clear();
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> clearGlobal() {
            this.global.clear();
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> clearVariable() {
            this.variable.clear();
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> copy(MolangEnvironment environment) {
            try {
                for (String name : environment.getObjects()) {
                    MolangObject runtimeObject;
                    MolangObject copy = environment.get(name).getCopy();
                    if (this.runtime.has(name) && (runtimeObject = this.runtime.get(name)).isMutable()) {
                        for (String field : copy.getKeys()) {
                            runtimeObject.set(field, copy.get(field).getCopy());
                        }
                        continue;
                    }
                    this.runtime.objects.put(name, copy);
                }
            }
            catch (MolangException e) {
                throw new RuntimeException("Failed to copy environment data", e);
            }
            return this;
        }

        @Override
        public MolangRuntime create() {
            return this.runtime;
        }
    }

    public static class Builder
    implements MolangEnvironmentBuilder<MolangRuntime> {
        private final MolangVariableStorage query;
        private final MolangVariableStorage global;
        private final MolangVariableStorage variable;
        private final Map<String, MolangObject> libraries;

        public Builder() {
            this.query = new MolangVariableStorage(true);
            this.global = new MolangVariableStorage(true);
            this.variable = new MolangVariableStorage(false);
            this.libraries = new HashMap<String, MolangObject>();
        }

        public Builder(Builder copy) {
            this.query = new MolangVariableStorage(copy.query);
            this.global = new MolangVariableStorage(copy.global);
            this.variable = new MolangVariableStorage(copy.variable);
            this.libraries = new HashMap<String, MolangObject>(copy.libraries);
        }

        public Builder loadLibrary(String name, MolangObject object) {
            this.libraries.put(name, object);
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> unloadLibrary(String name) {
            this.libraries.remove(name);
            return this;
        }

        public Builder setQuery(String name, MolangExpression value) {
            try {
                this.query.set(name, value);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder setGlobal(String name, MolangExpression value) {
            try {
                this.global.set(name, value);
            }
            catch (MolangRuntimeException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder setVariable(String name, MolangExpression value) {
            try {
                this.variable.set(name, value);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder removeQuery(String name) {
            try {
                this.query.remove(name);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder removeGlobal(String name) {
            try {
                this.global.remove(name);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder removeVariable(String name) {
            try {
                this.variable.remove(name);
            }
            catch (MolangRuntimeException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder clearLibraries() {
            this.libraries.clear();
            return this;
        }

        public Builder clearQuery() {
            this.query.clear();
            return this;
        }

        public Builder clearGlobal() {
            this.global.clear();
            return this;
        }

        public Builder clearVariable() {
            this.variable.clear();
            return this;
        }

        @Override
        public MolangEnvironmentBuilder<MolangRuntime> copy(MolangEnvironment environment) {
            try {
                block12: for (String name : environment.getObjects()) {
                    MolangObject runtimeObject;
                    name = name.toLowerCase(Locale.ROOT);
                    MolangObject copy = environment.get(name).getCopy();
                    switch (name) {
                        case "query": {
                            for (String field : copy.getKeys()) {
                                this.query.set(field, copy.get(field).getCopy());
                            }
                            continue block12;
                        }
                        case "global": {
                            for (String field : copy.getKeys()) {
                                this.global.set(field, copy.get(field).getCopy());
                            }
                            continue block12;
                        }
                        case "variable": {
                            for (String field : copy.getKeys()) {
                                this.variable.set(field, copy.get(field).getCopy());
                            }
                            continue block12;
                        }
                    }
                    if (this.libraries.containsKey(name) && (runtimeObject = environment.get(name)).isMutable()) {
                        for (String field : copy.getKeys()) {
                            runtimeObject.set(field, copy.get(field).getCopy());
                        }
                        continue;
                    }
                    this.libraries.put(name, copy);
                }
            }
            catch (MolangException e) {
                throw new RuntimeException("Failed to copy environment data", e);
            }
            return this;
        }

        @Override
        public MolangRuntime create() {
            return new MolangRuntime(new ImmutableMolangObject(this.query), new ImmutableMolangObject(this.global), this.variable, this.libraries);
        }

        public MolangObject getQuery() {
            return this.query;
        }

        public MolangObject getGlobal() {
            return this.global;
        }

        public MolangObject getVariable() {
            return this.variable;
        }
    }
}

