/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.opencl;

import foundry.veil.lib.opencl.CL;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class EXTDeviceFission {
    public static final int CL_DEVICE_PARTITION_EQUALLY_EXT = 16464;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS_EXT = 16465;
    public static final int CL_DEVICE_PARTITION_BY_NAMES_EXT = 16466;
    public static final int CL_DEVICE_PARTITION_BY_AFFINITY_DOMAIN_EXT = 16467;
    public static final int CL_AFFINITY_DOMAIN_L1_CACHE_EXT = 1;
    public static final int CL_AFFINITY_DOMAIN_L2_CACHE_EXT = 2;
    public static final int CL_AFFINITY_DOMAIN_L3_CACHE_EXT = 3;
    public static final int CL_AFFINITY_DOMAIN_L4_CACHE_EXT = 4;
    public static final int CL_AFFINITY_DOMAIN_NUMA_EXT = 16;
    public static final int CL_AFFINITY_DOMAIN_NEXT_FISSIONABLE_EXT = 256;
    public static final int CL_DEVICE_PARENT_DEVICE_EXT = 16468;
    public static final int CL_DEVICE_PARITION_TYPES_EXT = 16469;
    public static final int CL_DEVICE_AFFINITY_DOMAINS_EXT = 16470;
    public static final int CL_DEVICE_REFERENCE_COUNT_EXT = 16471;
    public static final int CL_DEVICE_PARTITION_STYLE_EXT = 16472;
    public static final int CL_PROPERTIES_LIST_END_EXT = 0;
    public static final int CL_PARTITION_BY_COUNTS_LIST_END_EXT = 0;
    public static final int CL_PARTITION_BY_NAMES_LIST_END_EXT = -1;
    public static final int CL_DEVICE_PARTITION_FAILED_EXT = -1057;
    public static final int CL_INVALID_PARTITION_COUNT_EXT = -1058;
    public static final int CL_INVALID_PARTITION_NAME_EXT = -1059;

    protected EXTDeviceFission() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="cl_int")
    public static int clReleaseDeviceEXT(@NativeType(value="cl_device_id") long device) {
        long __functionAddress = CL.getICD().clReleaseDeviceEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPI((long)device, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clRetainDeviceEXT(@NativeType(value="cl_device_id") long device) {
        long __functionAddress = CL.getICD().clRetainDeviceEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPI((long)device, (long)__functionAddress);
    }

    public static int nclCreateSubDevicesEXT(long in_device, long properties, int num_entries, long out_devices, long num_devices) {
        long __functionAddress = CL.getICD().clCreateSubDevicesEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)in_device);
        }
        return JNI.callPPPPI((long)in_device, (long)properties, (int)num_entries, (long)out_devices, (long)num_devices, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCreateSubDevicesEXT(@NativeType(value="cl_device_id") long in_device, @NativeType(value="cl_device_partition_property_ext const *") LongBuffer properties, @Nullable @NativeType(value="cl_device_id *") PointerBuffer out_devices, @Nullable @NativeType(value="cl_uint *") IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.checkNT((LongBuffer)properties);
            Checks.checkSafe((Buffer)num_devices, (int)1);
        }
        return EXTDeviceFission.nclCreateSubDevicesEXT(in_device, MemoryUtil.memAddress((LongBuffer)properties), Checks.remainingSafe((CustomBuffer)out_devices), MemoryUtil.memAddressSafe((Pointer)out_devices), MemoryUtil.memAddressSafe((IntBuffer)num_devices));
    }

    @NativeType(value="cl_int")
    public static int clCreateSubDevicesEXT(@NativeType(value="cl_device_id") long in_device, @NativeType(value="cl_device_partition_property_ext const *") long[] properties, @Nullable @NativeType(value="cl_device_id *") PointerBuffer out_devices, @Nullable @NativeType(value="cl_uint *") int[] num_devices) {
        long __functionAddress = CL.getICD().clCreateSubDevicesEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)in_device);
            Checks.checkNT((long[])properties);
            Checks.checkSafe((int[])num_devices, (int)1);
        }
        return JNI.callPPPPI((long)in_device, (long[])properties, (int)Checks.remainingSafe((CustomBuffer)out_devices), (long)MemoryUtil.memAddressSafe((Pointer)out_devices), (int[])num_devices, (long)__functionAddress);
    }
}

