/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.quasar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.impl.quasar.CodecUtil;
import foundry.veil.impl.quasar.MathUtil;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class ColorGradient {
    private static final Codec<Vector4fc> SINGLE_COLOR_CODEC = CodecUtil.VECTOR4F_CODEC.fieldOf("color").codec();
    private static final Codec<ColorGradient> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RGBPoint.CODEC.listOf().fieldOf("rgb_points").forGetter(ColorGradient::getPoints), (App)AlphaPoint.CODEC.listOf().fieldOf("alpha_points").forGetter(ColorGradient::getAlphaPoints)).apply((Applicative)instance, ColorGradient::new));
    public static final Codec<ColorGradient> CODEC = Codec.either(SINGLE_COLOR_CODEC, FULL_CODEC).xmap(either -> (ColorGradient)either.map(left -> new ColorGradient(left.x(), left.y(), left.z(), left.w()), right -> right), gradient -> {
        if (gradient.isConstant()) {
            class_243 point = gradient.points[0].color;
            return Either.left((Object)new Vector4f((float)point.field_1352, (float)point.field_1351, (float)point.field_1350, gradient.alphaPoints[0].alpha));
        }
        return Either.right((Object)gradient);
    });
    private final RGBPoint[] points;
    private final AlphaPoint[] alphaPoints;

    public ColorGradient(float red, float green, float blue, float alpha) {
        this.points = new RGBPoint[]{new RGBPoint(0.0f, new class_243((double)red, (double)green, (double)blue))};
        this.alphaPoints = new AlphaPoint[]{new AlphaPoint(0.0f, alpha)};
    }

    public ColorGradient(RGBPoint[] points, AlphaPoint[] alphaPoints) {
        this.points = points;
        this.alphaPoints = alphaPoints;
    }

    public ColorGradient(RGBPoint[] points) {
        this(points, new AlphaPoint[]{new AlphaPoint(0.0f, 0.0f), new AlphaPoint(1.0f, 1.0f)});
    }

    public ColorGradient(List<RGBPoint> points, List<AlphaPoint> alphaPoints) {
        this(points.toArray(new RGBPoint[0]), alphaPoints.toArray(new AlphaPoint[0]));
    }

    public ColorGradient(class_243 startColor, class_243 endColor, float startAlpha, float endAlpha) {
        this(new RGBPoint[]{new RGBPoint(0.0f, startColor), new RGBPoint(1.0f, endColor)}, new AlphaPoint[]{new AlphaPoint(0.0f, startAlpha), new AlphaPoint(1.0f, endAlpha)});
    }

    public ColorGradient(class_243 startColor, class_243 endColor) {
        this(new RGBPoint[]{new RGBPoint(0.0f, startColor), new RGBPoint(1.0f, endColor)});
    }

    public boolean isConstant() {
        return this.points.length == 1 && this.alphaPoints.length == 1;
    }

    public Vector4f getColor(float percentage) {
        return MathUtil.vec4fFromVec3(this.getRGB(percentage), this.getAlpha(percentage));
    }

    private float getAlpha(float percentage) {
        if (this.alphaPoints.length == 0) {
            return 1.0f;
        }
        if (this.alphaPoints.length == 1) {
            return this.alphaPoints[0].alpha;
        }
        for (int i = 0; i < this.alphaPoints.length - 1; ++i) {
            if (!(percentage >= this.alphaPoints[i].percent) || !(percentage <= this.alphaPoints[i + 1].percent)) continue;
            return class_3532.method_16439((float)((percentage - this.alphaPoints[i].percent) / (this.alphaPoints[i + 1].percent - this.alphaPoints[i].percent)), (float)this.alphaPoints[i].alpha, (float)this.alphaPoints[i + 1].alpha);
        }
        return this.alphaPoints[this.alphaPoints.length - 1].alpha;
    }

    private class_243 getRGB(float percentage) {
        if (this.points.length == 1) {
            return this.points[0].color;
        }
        for (int i = 0; i < this.points.length - 1; ++i) {
            if (!(percentage >= this.points[i].percent) || !(percentage <= this.points[i + 1].percent)) continue;
            return this.points[i].color.method_35590(this.points[i + 1].color, (double)((percentage - this.points[i].percent) / (this.points[i + 1].percent - this.points[i].percent)));
        }
        return this.points[this.points.length - 1].color;
    }

    public List<RGBPoint> getPoints() {
        return List.of(this.points);
    }

    public List<AlphaPoint> getAlphaPoints() {
        return List.of(this.alphaPoints);
    }

    public static class RGBPoint {
        public static final Codec<RGBPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("percent").forGetter(RGBPoint::getPercent), (App)class_243.field_38277.fieldOf("color").forGetter(RGBPoint::getColor)).apply((Applicative)instance, RGBPoint::new));
        float percent;
        class_243 color;

        RGBPoint(float percent, class_243 color) {
            this.percent = percent;
            this.color = color;
        }

        float getPercent() {
            return this.percent;
        }

        class_243 getColor() {
            return this.color;
        }
    }

    public static class AlphaPoint {
        public static final Codec<AlphaPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("percent").forGetter(AlphaPoint::getPercent), (App)Codec.FLOAT.fieldOf("alpha").forGetter(AlphaPoint::getAlpha)).apply((Applicative)instance, AlphaPoint::new));
        float percent;
        float alpha;

        AlphaPoint(float percent, float alpha) {
            this.percent = percent;
            this.alpha = alpha;
        }

        float getPercent() {
            return this.percent;
        }

        float getAlpha() {
            return this.alpha;
        }
    }
}

