/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import foundry.veil.impl.client.render.shader.modifier.SimpleShaderModification;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VertexShaderModification
extends SimpleShaderModification {
    private final Attribute[] attributes;
    private final Map<String, String> mapper;

    public VertexShaderModification(int version, int priority, class_2960[] includes, @Nullable String output, @Nullable String uniform, ShaderModification.Function[] functions, Attribute[] attributes) {
        super(version, priority, includes, output, uniform, functions);
        this.attributes = attributes;
        this.mapper = new HashMap<String, String>(this.attributes.length);
    }

    @Override
    protected void processBody(int pointer, StringBuilder builder) throws IOException {
        if (this.attributes.length > 0) {
            Int2ObjectArrayMap validInputs = new Int2ObjectArrayMap();
            Matcher matcher = IN_PATTERN.matcher(builder);
            while (matcher.find()) {
                pointer = matcher.end();
                validInputs.put(validInputs.size(), new Attribute(validInputs.size(), matcher.group(1), matcher.group(2)));
            }
            matcher.reset();
            this.mapper.clear();
            for (Attribute attribute : this.attributes) {
                Attribute sourceAttribute = (Attribute)validInputs.get(attribute.index);
                if (sourceAttribute == null) {
                    builder.insert(pointer, "layout(location = " + attribute.index + ") in " + attribute.type + " " + attribute.name + ";\n");
                    this.mapper.put(attribute.name, attribute.name);
                    continue;
                }
                if (!sourceAttribute.type.equals(attribute.type)) {
                    throw new IOException("Expected attribute " + attribute.index + " to be " + attribute.type + " but was " + sourceAttribute.type);
                }
                this.mapper.put(attribute.name, sourceAttribute.name);
            }
        }
        super.processBody(pointer, builder);
    }

    @Override
    protected String getPlaceholder(String key) {
        String name = this.mapper.get(key);
        return name != null ? name : super.getPlaceholder(key);
    }

    public record Attribute(int index, String type, String name) {
    }
}

